/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractShifterTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private Direction facing = null;
    protected BlockPos endPos = null;

    protected <T extends AbstractShifterTileEntity> AbstractShifterTileEntity(TileEntityType<T> type) {
        super(type);
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!state.func_196959_b((IProperty)ESProperties.FACING)) {
                return Direction.DOWN;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        }
        return this.facing;
    }

    public void refreshCache() {
        BlockState target;
        int extension;
        this.facing = null;
        Direction dir = this.getFacing();
        int maxChutes = (Integer)ESConfig.itemChuteRange.get();
        for (extension = 1; extension <= maxChutes && (target = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(dir, extension))).func_177230_c() == ESBlocks.itemChute && target.func_177229_b(ESProperties.AXIS) == dir.func_176740_k(); ++extension) {
        }
        this.endPos = this.field_174879_c.func_177967_a(dir, extension);
    }

    public static ItemStack ejectItem(World world, BlockPos pos, Direction fromSide, ItemStack stack) {
        LazyOptional outputCap;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        TileEntity outputTE = world.func_175625_s(pos);
        if (outputTE != null && (outputCap = outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromSide.func_176734_d())).isPresent()) {
            IItemHandler outHandler = (IItemHandler)outputCap.orElseThrow(NullPointerException::new);
            for (int i = 0; i < outHandler.getSlots(); ++i) {
                ItemStack outStack = outHandler.insertItem(i, stack, false);
                if (outStack.func_190916_E() == stack.func_190916_E()) continue;
                return outStack;
            }
            return stack;
        }
        ItemEntity ent = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        ent.func_213317_d(Vec3d.field_186680_a);
        world.func_217376_c((Entity)ent);
        return ItemStack.field_190927_a;
    }

    public static FluidStack ejectFluid(World world, BlockPos pos, Direction fromSide, FluidStack stack) {
        LazyOptional outHandlerCon;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        TileEntity outputTE = world.func_175625_s(pos);
        if (outputTE != null && (outHandlerCon = outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fromSide.func_176734_d())).isPresent()) {
            IFluidHandler outHandler = (IFluidHandler)outHandlerCon.orElseThrow(NullPointerException::new);
            int filled = outHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            FluidStack out = stack.copy();
            out.shrink(filled);
            return out;
        }
        return stack;
    }
}

