/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class HopperFilterTileEntity
extends TileEntity
implements INBTReceiver {
    @ObjectHolder(value="hopper_filter")
    public static TileEntityType<HopperFilterTileEntity> TYPE = null;
    private Direction.Axis axisCache = null;
    private ItemStack filter = ItemStack.field_190927_a;
    private LazyOptional<IItemHandler> passedHandler = null;

    public HopperFilterTileEntity() {
        super(TYPE);
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendNBTToClient(filter.func_77955_b(new CompoundNBT()), this.field_174879_c));
        this.func_70296_d();
    }

    private Direction.Axis getAxis() {
        if (this.axisCache == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() == ESBlocks.hopperFilter) {
                this.axisCache = (Direction.Axis)state.func_177229_b(ESProperties.AXIS);
            } else {
                return Direction.Axis.Y;
            }
        }
        return this.axisCache;
    }

    public void clearCache() {
        this.axisCache = null;
        if (this.passedHandler != null) {
            this.passedHandler.invalidate();
            this.passedHandler = null;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("filter", (INBT)this.filter.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("filter"));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side.func_176740_k() == this.getAxis()) {
            if (this.passedHandler == null) {
                LazyOptional src;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side.func_176734_d()));
                if (te != null && (src = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
                    this.passedHandler = LazyOptional.of(() -> new ProxyItemHandler(src));
                    src.addListener(handler -> {
                        if (this.passedHandler != null) {
                            this.passedHandler.invalidate();
                        }
                        this.passedHandler = null;
                    });
                } else {
                    return LazyOptional.empty();
                }
            }
            return this.passedHandler;
        }
        return super.getCapability(cap, side);
    }

    private static boolean matchFilter(ItemStack query, ItemStack filt) {
        CompoundNBT nbt;
        if (filt.func_190926_b()) {
            return false;
        }
        if (filt.func_77973_b() instanceof BlockItem && ((BlockItem)filt.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock && (nbt = filt.func_77978_p()) != null) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("BlockEntityTag"), (NonNullList)nonnulllist);
            for (ItemStack singleFilt : nonnulllist) {
                if (!HopperFilterTileEntity.matchFilter(query, singleFilt)) continue;
                return true;
            }
            return false;
        }
        return query.func_77973_b() == filt.func_77973_b();
    }

    private class ProxyItemHandler
    implements IItemHandler {
        private final LazyOptional<IItemHandler> src;

        private ProxyItemHandler(LazyOptional<IItemHandler> src) {
            this.src = src;
        }

        private IItemHandler getHandler() {
            if (this.src.isPresent()) {
                return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
            }
            if (HopperFilterTileEntity.this.passedHandler != null) {
                HopperFilterTileEntity.this.passedHandler.invalidate();
            }
            HopperFilterTileEntity.this.passedHandler = null;
            return new BlankHandler();
        }

        public int getSlots() {
            return this.getHandler().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getHandler().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter)) {
                return this.getHandler().insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (HopperFilterTileEntity.matchFilter(this.getStackInSlot(slot), HopperFilterTileEntity.this.filter)) {
                return this.getHandler().extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.getHandler().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter) && this.getHandler().isItemValid(slot, stack);
        }
    }

    private static class BlankHandler
    implements IItemHandler {
        private BlankHandler() {
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }
}

