/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.tileentities.SortingHopperTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SortingHopper
extends ContainerBlock
implements IReadable {
    public static final DirectionProperty FACING = HopperBlock.field_176430_a;
    public static final BooleanProperty ENABLED = HopperBlock.field_176429_b;
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape field_196326_A = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IHopper.field_200101_a, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IHopper.field_200101_a;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    protected SortingHopper(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected SortingHopper() {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.0f));
        String name = "sorting_hopper";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return field_196326_A;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IHopper.field_200101_a;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_196000_l().func_176734_d();
        if (enumfacing == Direction.UP) {
            enumfacing = Direction.DOWN;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)enumfacing)).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(!context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new SortingHopperTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (ESConfig.isWrench(playerIn.func_184586_b(hand))) {
                worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)FACING));
                if (te instanceof SortingHopperTileEntity) {
                    ((SortingHopperTileEntity)te).resetCache();
                }
                return ActionResultType.SUCCESS;
            }
            if (te instanceof SortingHopperTileEntity) {
                playerIn.func_213829_a((INamedContainerProvider)((SortingHopperTileEntity)te));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        boolean block;
        boolean bl = block = !worldIn.func_175640_z(pos);
        if (block != (Boolean)state.func_177229_b((Property)ENABLED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(block)), 4);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof SortingHopperTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((SortingHopperTileEntity)te));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @Override
    public float read(World world, BlockPos pos, BlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            float f = 0.0f;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                f += (float)stack.func_190916_E() / (float)Math.min(64, stack.func_77976_d());
            }
            f /= (float)inv.func_70302_i_();
            return f *= 15.0f;
        }
        return 0.0f;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ENABLED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.sorting_hopper.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.sorting_hopper.quip").func_230530_a_(ESConfig.TT_QUIP));
    }
}

