/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class WitherCannon
extends Block {
    @ObjectHolder(value="cannon_skull")
    public static EntityType<CannonSkull> ENT_TYPE;

    protected WitherCannon() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(50.0f, 1200.0f).func_200947_a(SoundType.field_185851_d));
        String name = "wither_cannon";
        this.setRegistryName(name);
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ESProperties.FACING, (Comparable)context.func_196010_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ESProperties.FACING}).func_206894_a(new Property[]{ESProperties.REDSTONE_BOOL});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                BlockState endState = (BlockState)state.func_235896_a_((Property)ESProperties.FACING);
                worldIn.func_175656_a(pos, endState);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.wither_cannon"));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos srcPos, boolean flag) {
        boolean powered = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        boolean wasActive = (Boolean)state.func_177229_b((Property)ESProperties.REDSTONE_BOOL);
        if (powered && !wasActive) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!powered && wasActive) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        Direction dir = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        BlockPos spawnPos = pos.func_177972_a(dir);
        CannonSkull skull = new CannonSkull(ENT_TYPE, (World)world);
        skull.func_70012_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, dir.func_185119_l() + 180.0f, dir.func_96559_d() * -90);
        skull.func_213293_j((float)dir.func_82601_c() / 5.0f, (float)dir.func_96559_d() / 5.0f, (float)dir.func_82599_e() / 5.0f);
        skull.field_70232_b = (double)dir.func_82601_c() / 20.0;
        skull.field_70233_c = (double)dir.func_96559_d() / 20.0;
        skull.field_70230_d = (double)dir.func_82599_e() / 20.0;
        world.func_217376_c((Entity)skull);
    }

    public static class CannonSkull
    extends WitherSkullEntity {
        private int lifespan = 60;

        public CannonSkull(EntityType<CannonSkull> type, World world) {
            super(type, world);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.lifespan-- <= 0) {
                this.field_70170_p.func_195589_b((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                this.func_70106_y();
            }
        }

        public void func_213281_b(CompoundNBT nbt) {
            super.func_213281_b(nbt);
            nbt.func_74768_a("lifetime", this.lifespan);
        }

        public void func_70037_a(CompoundNBT nbt) {
            super.func_70037_a(nbt);
            this.lifespan = nbt.func_74762_e("lifetime");
        }

        protected void func_70227_a(RayTraceResult result) {
            if (!this.field_70170_p.field_72995_K) {
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                    entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
                    if (entity instanceof LivingEntity) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1));
                    }
                }
                this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f, false, Explosion.Mode.BREAK);
                this.func_70106_y();
            }
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }
    }
}

