/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IWireConnect;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.RedstoneReceiverTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneReceiver
extends ContainerBlock
implements IWireConnect {
    public RedstoneReceiver() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.5f).func_200947_a(SoundType.field_185851_d));
        String name = "redstone_receiver";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(ESProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity te = worldIn.func_175625_s(pos);
        if (ILinkTE.isLinkTool(heldItem) && te instanceof RedstoneReceiverTileEntity) {
            if (!worldIn.field_72995_K) {
                ((RedstoneReceiverTileEntity)te).wrench(heldItem, playerIn);
            }
            return ActionResultType.SUCCESS;
        }
        Item dye = heldItem.func_77973_b();
        if (dye instanceof DyeItem && te instanceof RedstoneReceiverTileEntity) {
            if (!worldIn.field_72995_K) {
                ((RedstoneReceiverTileEntity)te).dye(((DyeItem)dye).func_195962_g());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_rec.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_rec.linking"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_rec.dyes"));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new RedstoneReceiverTileEntity();
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            return Math.min(Math.round(((RedstoneReceiverTileEntity)te).getPower()), 15);
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{ESProperties.COLOR});
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            ((RedstoneReceiverTileEntity)te).buildDependents();
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            ((RedstoneReceiverTileEntity)te).buildDependents();
        }
    }
}

