/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.redstone.DefaultRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

@ParametersAreNonnullByDefault
public class RedstoneUtil
extends BlockUtil {
    @CapabilityInject(value=IRedstoneHandler.class)
    public static Capability<IRedstoneHandler> REDSTONE_CAPABILITY = null;
    public static final float MAX_POWER = 1.0E9f;
    public static final int DELAY = 2;

    public static int getMaxRange() {
        return (Integer)ESConfig.maxRedstoneRange.get();
    }

    public static float sanitize(float input) {
        if (input != input) {
            return 0.0f;
        }
        if (input >= 1.0E9f) {
            return 1.0E9f;
        }
        if (input <= 0.0f) {
            return 0.0f;
        }
        return input;
    }

    public static int clampToVanilla(float input) {
        if ((input = RedstoneUtil.sanitize(input)) > 15.0f) {
            return 15;
        }
        return Math.round(input);
    }

    public static boolean didChange(float prevVal, float newVal) {
        return newVal == 0.0f ^ prevVal == 0.0f || (double)(Math.abs(newVal - prevVal) / newVal) > 5.0E-5;
    }

    public static int getRedstoneOnSide(World w, BlockPos pos, Direction dir) {
        BlockPos offsetPos = pos.func_177972_a(dir);
        BlockState state = w.func_180495_p(offsetPos);
        return state.func_177230_c() == Blocks.field_150488_af ? ((Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O)).intValue() : w.func_175651_c(offsetPos, dir);
    }

    public static int getRedstoneAtPos(World w, BlockPos pos) {
        int val = 0;
        for (Direction dir : Direction.values()) {
            val = Math.max(val, RedstoneUtil.getRedstoneOnSide(w, pos, dir));
        }
        return val;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float interpretFormulaString(String input) {
        ArrayList<Constable> formula;
        boolean working;
        float output;
        block30: {
            output = 0.0f;
            working = true;
            formula = new ArrayList<Constable>();
            String opChars = "+-xX*/()^";
            int index = 0;
            while (index < input.length()) {
                int subInd;
                for (subInd = index; subInd < input.length() && (Character.isDigit(input.charAt(subInd)) || input.charAt(subInd) == '.'); ++subInd) {
                }
                if (index < subInd) {
                    try {
                        float val = Float.parseFloat(input.substring(index, subInd));
                        formula.add(Float.valueOf(val));
                        index = subInd;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        working = false;
                        break;
                    }
                }
                if (input.charAt(index) == 'e') {
                    formula.add(Float.valueOf((float)Math.E));
                    ++index;
                    continue;
                }
                if (input.length() > index + 1 && input.substring(index, index + 2).toLowerCase().equals("pi")) {
                    formula.add(Float.valueOf((float)Math.PI));
                    index += 2;
                    continue;
                }
                if ("+-xX*/()^".contains(input.substring(index, index + 1))) {
                    char c = input.charAt(index);
                    formula.add(Character.valueOf(c == 'x' || c == 'X' ? (char)'*' : input.charAt(index)));
                    ++index;
                    continue;
                }
                if (input.charAt(index) == 'E') {
                    formula.add(Character.valueOf('*'));
                    formula.add(Float.valueOf(10.0f));
                    formula.add(Character.valueOf('^'));
                    ++index;
                    continue;
                }
                if (input.charAt(index) == ' ') {
                    ++index;
                    continue;
                }
                working = false;
                break;
            }
            if (!working) break block30;
            int openParens = 0;
            boolean prevNumb = false;
            boolean prevReqNextNumber = false;
            boolean bl = false;
            for (Object e : formula) {
                boolean bl2;
                boolean numberFromRight;
                boolean numberFromLeft;
                block29: {
                    block31: {
                        numberFromLeft = false;
                        numberFromRight = false;
                        if (!(e instanceof Character)) break block31;
                        switch (((Character)e).charValue()) {
                            case '(': {
                                ++openParens;
                                numberFromLeft = true;
                                break block29;
                            }
                            case ')': {
                                if (openParens == 0) {
                                    working = false;
                                    break;
                                }
                                --openParens;
                                numberFromRight = true;
                                break block29;
                            }
                            case '*': 
                            case '+': 
                            case '/': 
                            case '^': {
                                if (prevNumb) {
                                    bl2 = true;
                                    break block29;
                                } else {
                                    working = false;
                                    break;
                                }
                            }
                            case '-': {
                                numberFromLeft = true;
                                bl2 = true;
                                break block29;
                            }
                            default: {
                                Essentials.logger.warn("Invalid formula state! Report to mod author, and give them this: " + input);
                                working = false;
                                break;
                            }
                        }
                        break;
                    }
                    if (e instanceof Float) {
                        numberFromLeft = true;
                        numberFromRight = true;
                    } else {
                        Essentials.logger.warn("Invalid formula state! Report to mod author, and give them this: " + input);
                        working = false;
                        break;
                    }
                }
                if (prevReqNextNumber && !numberFromLeft) {
                    working = false;
                    break;
                }
                prevNumb = numberFromRight;
                prevReqNextNumber = bl2;
                bl2 = false;
            }
            if (prevReqNextNumber) {
                working = false;
            }
            for (int i = 0; i < openParens; ++i) {
                formula.add(Character.valueOf(')'));
            }
        }
        if (!working) return output;
        ArrayList<Object> formulaActive = new ArrayList<Object>(formula.size());
        formulaActive.addAll(formula);
        try {
            float value = RedstoneUtil.operate(formulaActive);
            if (Float.isNaN(value)) {
                return 0.0f;
            }
            if (!Float.isInfinite(value)) return value;
            return Math.copySign(Float.MAX_VALUE, value);
        }
        catch (Exception e) {
            Essentials.logger.warn("Error interpreting formula; Report to mod author");
            e.printStackTrace();
            Essentials.logger.warn("Full formula data: [" + input + "]");
            Essentials.logger.warn("Parsed formula: ");
            Iterator iterator = formula.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Essentials.logger.warn("\tFormula item: " + e2.toString());
            }
            return 0.0f;
        }
    }

    public static void registerCap() {
        CapabilityManager.INSTANCE.register(IRedstoneHandler.class, (Capability.IStorage)new EmptyStorage(), DefaultRedstoneHandler::new);
    }

    private static float operate(ArrayList<Object> formula) {
        if (formula.size() == 0) {
            return 0.0f;
        }
        while (formula.size() > 1) {
            int i;
            int openParenIndex = formula.indexOf(Character.valueOf('('));
            if (openParenIndex != -1) {
                int openParens = 1;
                int closeParenIndex = openParenIndex;
                while (openParens != 0 && closeParenIndex < formula.size() - 1) {
                    Object o;
                    if (!((o = formula.get(++closeParenIndex)) instanceof Character)) continue;
                    if (((Character)o).charValue() == '(') {
                        ++openParens;
                        continue;
                    }
                    if (((Character)o).charValue() != ')') continue;
                    --openParens;
                }
                ArrayList<Object> subForm = new ArrayList<Object>(closeParenIndex - openParenIndex - 1);
                formula.remove(openParenIndex);
                for (i = openParenIndex; i < closeParenIndex - 1; ++i) {
                    subForm.add(formula.get(openParenIndex));
                    formula.remove(openParenIndex);
                }
                formula.remove(openParenIndex);
                formula.add(openParenIndex, Float.valueOf(RedstoneUtil.operate(subForm)));
                continue;
            }
            int expIndex = formula.indexOf(Character.valueOf('^'));
            if (expIndex != -1) {
                expIndex = RedstoneUtil.checkForNeg(formula, expIndex);
                float prev = ((Float)formula.get(expIndex - 1)).floatValue();
                float next = ((Float)formula.get(expIndex + 1)).floatValue();
                formula.remove(expIndex - 1);
                formula.remove(expIndex - 1);
                formula.remove(expIndex - 1);
                formula.add(expIndex - 1, Float.valueOf((float)Math.pow(prev, next)));
                continue;
            }
            int multIndex = formula.indexOf(Character.valueOf('*'));
            if (multIndex != -1) {
                multIndex = RedstoneUtil.checkForNeg(formula, multIndex);
                float prev = ((Float)formula.get(multIndex - 1)).floatValue();
                float next = ((Float)formula.get(multIndex + 1)).floatValue();
                formula.remove(multIndex - 1);
                formula.remove(multIndex - 1);
                formula.remove(multIndex - 1);
                formula.add(multIndex - 1, Float.valueOf(prev * next));
                continue;
            }
            boolean didMult = false;
            for (i = 0; i < formula.size() - 1; ++i) {
                Object o = formula.get(i);
                Object o1 = formula.get(i + 1);
                if (!(o instanceof Float) || !(o1 instanceof Float)) continue;
                formula.remove(i);
                formula.remove(i);
                formula.add(i, Float.valueOf(((Float)o).floatValue() * ((Float)o1).floatValue()));
                didMult = true;
                break;
            }
            if (didMult) continue;
            int divIndex = formula.indexOf(Character.valueOf('/'));
            if (divIndex != -1) {
                divIndex = RedstoneUtil.checkForNeg(formula, divIndex);
                float prev = ((Float)formula.get(divIndex - 1)).floatValue();
                float next = ((Float)formula.get(divIndex + 1)).floatValue();
                formula.remove(divIndex - 1);
                formula.remove(divIndex - 1);
                formula.remove(divIndex - 1);
                formula.add(divIndex - 1, Float.valueOf(prev / next));
                continue;
            }
            int sumIndex = formula.indexOf(Character.valueOf('+'));
            if (sumIndex != -1) {
                sumIndex = RedstoneUtil.checkForNeg(formula, sumIndex);
                float prev = ((Float)formula.get(sumIndex - 1)).floatValue();
                float next = ((Float)formula.get(sumIndex + 1)).floatValue();
                formula.remove(sumIndex - 1);
                formula.remove(sumIndex - 1);
                formula.remove(sumIndex - 1);
                formula.add(sumIndex - 1, Float.valueOf(prev + next));
                continue;
            }
            int subIndex = formula.indexOf(Character.valueOf('-'));
            if (subIndex == -1) continue;
            if (subIndex == 0) {
                formula.remove(0);
                Object o = formula.get(0);
                formula.remove(0);
                formula.add(0, Float.valueOf(-((Float)o).floatValue()));
                continue;
            }
            subIndex = RedstoneUtil.checkForNeg(formula, subIndex);
            float prev = ((Float)formula.get(subIndex - 1)).floatValue();
            float next = ((Float)formula.get(subIndex + 1)).floatValue();
            formula.remove(subIndex - 1);
            formula.remove(subIndex - 1);
            formula.remove(subIndex - 1);
            formula.add(subIndex - 1, Float.valueOf(prev - next));
        }
        return ((Float)formula.get(0)).floatValue();
    }

    private static int checkForNeg(ArrayList<Object> formula, int opIndex) {
        Float o;
        if (formula.size() - opIndex > 2 && (o = RedstoneUtil.applyNeg(formula.get(opIndex + 1), formula.get(opIndex + 2))) != null) {
            formula.remove(opIndex + 1);
            formula.remove(opIndex + 1);
            formula.add(opIndex + 1, o);
        }
        if (opIndex > 1 && (o = RedstoneUtil.applyNeg(formula.get(opIndex - 2), formula.get(opIndex - 1))) != null) {
            formula.remove(--opIndex - 1);
            formula.remove(opIndex - 1);
            formula.add(opIndex - 1, o);
        }
        return opIndex;
    }

    private static Float applyNeg(Object item1, Object item2) {
        if (item1 instanceof Character && ((Character)item1).charValue() == '-') {
            return Float.valueOf(-1.0f * ((Float)item2).floatValue());
        }
        return null;
    }

    private static class EmptyStorage
    implements Capability.IStorage<IRedstoneHandler> {
        private EmptyStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IRedstoneHandler> capability, IRedstoneHandler instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<IRedstoneHandler> capability, IRedstoneHandler instance, Direction side, INBT nbt) {
        }
    }
}

