/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.items.CircuitWrench;
import com.Da_Technomancer.essentials.packets.ConfigureWrenchOnServer;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CircuitWrenchScreen
extends ContainerScreen<CircuitWrenchContainer> {
    private static final ResourceLocation SEARCH_BAR_TEXTURE = new ResourceLocation("essentials", "textures/gui/search_bar.png");
    private static final ResourceLocation ROW_TEXTURE = new ResourceLocation("essentials", "textures/gui/row.png");
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("essentials", "textures/gui/circuit/missing.png");
    private static final int ROWS = 8;
    private static final int COLUMNS = 8;
    private TextFieldWidget searchBar;
    private final ArrayList<Integer> options = new ArrayList();
    private static final Style style = Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_RED);

    public CircuitWrenchScreen(CircuitWrenchContainer cont, PlayerInventory playerInventory, ITextComponent text) {
        super((Container)cont, playerInventory, text);
        this.field_147000_g = 162;
        this.field_146999_f = 144;
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            this.options.add(i);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.searchBar = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 4, this.field_147009_r + 8, 140, 18, (ITextComponent)new TranslationTextComponent("container.search_bar"));
        this.searchBar.func_146205_d(false);
        this.searchBar.func_146193_g(-1);
        this.searchBar.func_146204_h(-1);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146203_f(20);
        this.searchBar.func_212954_a(this::filterChanged);
        this.field_230705_e_.add(this.searchBar);
        this.func_212928_a((IGuiEventListener)this.searchBar);
    }

    public void func_231152_a_(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String s = this.searchBar.func_146179_b();
        this.func_231158_b_(p_resize_1_, p_resize_2_, p_resize_3_);
        this.searchBar.func_146180_a(s);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.searchBar.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.searchBar.func_212955_f() || super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private int getSelectedMode(float xPos, float yPos) {
        int xInd = (int)Math.floor((xPos -= (float)this.field_147003_i) / 18.0f);
        int yInd = (int)Math.floor((yPos -= (float)(this.field_147009_r + 18)) / 18.0f);
        int index = xInd + yInd * 8;
        if (xInd < 0 || yInd < 0 || xInd >= 8 || yInd >= 8 || index >= this.options.size() || index < 0) {
            return -1;
        }
        return this.options.get(index);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        int index = this.getSelectedMode(mouseX, mouseY);
        if (index >= 0) {
            ArrayList<TranslationTextComponent> tt = new ArrayList<TranslationTextComponent>();
            tt.add(new TranslationTextComponent(CircuitWrench.MODES.get(index).func_149739_a()));
            AbstractTile block = CircuitWrench.MODES.get(index);
            block.func_190948_a(ItemStack.field_190927_a, null, tt, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            this.func_238654_b_(matrix, tt, mouseX, mouseY);
        }
        RenderSystem.disableLighting();
        RenderSystem.disableBlend();
        this.searchBar.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    private void filterChanged(String newFilter) {
        this.options.clear();
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            AbstractTile tile = CircuitWrench.MODES.get(i);
            String name = I18n.func_135052_a((String)tile.func_149739_a(), (Object[])new Object[0]).toLowerCase();
            if (!name.contains(newFilter.toLowerCase().trim())) continue;
            this.options.add(i);
        }
    }

    public boolean func_231044_a_(double xPos, double yPos, int button) {
        if (button != 0) {
            return super.func_231044_a_(xPos, yPos, button);
        }
        int index = this.getSelectedMode((int)xPos, (int)yPos);
        if (index < 0) {
            return super.func_231044_a_(xPos, yPos, button);
        }
        EssentialsPackets.channel.sendToServer((Object)new ConfigureWrenchOnServer(index));
        this.field_230706_i_.field_71439_g.func_71053_j();
        this.field_213127_e.field_70458_d.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.circuit_wrench_setting").func_230530_a_(style).func_230529_a_((ITextComponent)new TranslationTextComponent(CircuitWrench.MODES.get(index).func_149739_a())), this.field_213127_e.field_70458_d.func_110124_au());
        return true;
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        int i;
        this.field_230706_i_.func_110434_K().func_110577_a(SEARCH_BAR_TEXTURE);
        CircuitWrenchScreen.func_238463_a_((MatrixStack)matrix, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)18, (int)this.field_146999_f, (int)18);
        this.field_230706_i_.func_110434_K().func_110577_a(ROW_TEXTURE);
        for (i = 1; i <= 8; ++i) {
            CircuitWrenchScreen.func_238463_a_((MatrixStack)matrix, (int)this.field_147003_i, (int)(this.field_147009_r + i * 18), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)18, (int)this.field_146999_f, (int)18);
        }
        for (i = 0; i < this.options.size(); ++i) {
            Integer ind = this.options.get(i);
            ResourceLocation sprite = CircuitWrench.ICONS.get(ind);
            if (sprite == null) {
                sprite = MISSING_TEXTURE;
            }
            this.field_230706_i_.func_110434_K().func_110577_a(sprite);
            CircuitWrenchScreen.func_238463_a_((MatrixStack)matrix, (int)(i % 8 * 18 + 1 + this.field_147003_i), (int)(i / 8 * 18 + 19 + this.field_147009_r), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int p_230451_2_, int p_230451_3_) {
    }
}

