/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.AutoCrafterContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class AutoCrafterTileEntity
extends TileEntity
implements INBTReceiver,
INamedContainerProvider {
    @ObjectHolder(value="auto_crafter")
    private static TileEntityType<AutoCrafterTileEntity> TYPE = null;
    private final ItemStack[] inv = new ItemStack[19];
    private final Inventory iInv = new Inventory(this.inv, this);
    private boolean redstone = false;
    @Nullable
    private RecipeManager recipeManager = null;
    @Nullable
    public ResourceLocation recipe;
    private final LazyOptional<IItemHandler> hanOptional = LazyOptional.of(() -> new InventoryHandler());

    public AutoCrafterTileEntity() {
        super(TYPE);
        Arrays.fill(this.inv, ItemStack.field_190927_a);
    }

    public RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            this.recipeManager = this.field_145850_b.field_72995_K ? Minecraft.func_71410_x().func_147114_u().func_199526_e() : this.field_145850_b.func_73046_m().func_199529_aN();
        }
        return this.recipeManager;
    }

    @Nullable
    public static IRecipe<CraftingInventory> validateRecipe(ResourceLocation rec, RecipeManager manager) {
        if (rec == null) {
            return null;
        }
        return manager.func_215367_a(rec).map(AutoCrafterTileEntity::validateRecipe).orElse(null);
    }

    @Nullable
    public IRecipe<CraftingInventory> findRecipe(ItemStack[] inventory) {
        IRecipe<CraftingInventory> iRecipe;
        if (this.recipe == null) {
            CraftingInventory fakeInv = new CraftingInventory(new Container(null, 0){

                public boolean func_75145_c(PlayerEntity playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int i = 0; i < 9; ++i) {
                fakeInv.func_70299_a(i, inventory[i + 10]);
            }
            iRecipe = this.findRecipe(fakeInv);
        } else {
            iRecipe = AutoCrafterTileEntity.validateRecipe(this.recipe, this.getRecipeManager());
        }
        return iRecipe;
    }

    @Nullable
    private IRecipe<CraftingInventory> findRecipe(CraftingInventory fakeInv) {
        IRecipe<CraftingInventory> iRecipe;
        if (this.recipe == null) {
            Optional recipeOptional = this.getRecipeManager().func_215371_a(IRecipeType.field_222149_a, (IInventory)fakeInv, this.field_145850_b);
            iRecipe = AutoCrafterTileEntity.validateRecipe(recipeOptional.orElse(null));
        } else {
            iRecipe = AutoCrafterTileEntity.validateRecipe(this.recipe, this.getRecipeManager());
        }
        return iRecipe;
    }

    @Nullable
    private static IRecipe<CraftingInventory> validateRecipe(IRecipe<?> rec) {
        if (rec == null || rec.func_222127_g() != IRecipeType.field_222149_a || !rec.func_194133_a(3, 3)) {
            return null;
        }
        return rec;
    }

    public void redstoneUpdate(boolean newReds) {
        if (newReds != this.redstone) {
            this.redstone = newReds;
            this.func_70296_d();
            if (this.redstone && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                CraftingInventory fakeInv = new CraftingInventory(new Container(null, 0){

                    public boolean func_75145_c(PlayerEntity playerIn) {
                        return false;
                    }
                }, 3, 3);
                for (int i = 0; i < 9; ++i) {
                    fakeInv.func_70299_a(i, this.inv[i + 10]);
                }
                IRecipe<CraftingInventory> iRecipe = this.findRecipe(fakeInv);
                if (iRecipe != null) {
                    ItemStack output = this.recipe != null ? iRecipe.func_77571_b() : iRecipe.func_77572_b((IInventory)fakeInv);
                    if (this.inv[9].func_190926_b() || BlockUtil.sameItem(this.inv[9], output) && output.func_190916_E() + this.inv[9].func_190916_E() <= this.inv[9].func_77976_d()) {
                        Object ingredients;
                        if (this.recipe == null) {
                            ingredients = new ArrayList(9);
                            for (int i = 10; i < 19; ++i) {
                                if (this.inv[i].func_190926_b()) continue;
                                ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.inv[i]}));
                            }
                        } else {
                            ingredients = iRecipe.func_192400_c();
                        }
                        int[] used = new int[9];
                        Iterator iterator = ingredients.iterator();
                        block2: while (iterator.hasNext()) {
                            Ingredient ingr = (Ingredient)iterator.next();
                            if (ingr.func_203189_d()) continue;
                            for (int i = 8; i >= 0; --i) {
                                if (this.inv[i].func_190916_E() - used[i] <= 0 || !ingr.test(this.inv[i])) continue;
                                int n = i;
                                used[n] = used[n] + 1;
                                continue block2;
                            }
                            return;
                        }
                        ArrayList<ItemStack> containers = new ArrayList<ItemStack>(0);
                        for (int i = 0; i < 9; ++i) {
                            if (used[i] != 0 && this.inv[i].hasContainerItem()) {
                                ItemStack cont = this.inv[i].getContainerItem().func_77946_l();
                                cont.func_190920_e(used[i]);
                                containers.add(cont);
                            }
                            this.inv[i].func_190918_g(used[i]);
                        }
                        if (this.inv[9].func_190926_b()) {
                            this.inv[9] = output.func_77946_l();
                        } else {
                            this.inv[9].func_190917_f(output.func_190916_E());
                        }
                        for (ItemStack s : containers) {
                            int slot = -1;
                            for (int i = 0; i < 9; ++i) {
                                if (BlockUtil.sameItem(s, this.inv[i])) {
                                    slot = i;
                                    break;
                                }
                                if (!this.inv[i].func_190926_b()) continue;
                                slot = i;
                                break;
                            }
                            if (slot == -1) {
                                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + Math.random()), (double)((double)this.field_174879_c.func_177956_o() + Math.random()), (double)((double)this.field_174879_c.func_177952_p() + Math.random()), (ItemStack)s);
                                continue;
                            }
                            if (this.inv[slot].func_190926_b()) {
                                this.inv[slot] = s;
                                continue;
                            }
                            this.inv[slot].func_190917_f(s.func_190916_E());
                        }
                    }
                }
            }
        }
    }

    public void dropItems() {
        for (int i = 0; i < 10; ++i) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inv[i]);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        String recPath = nbt.func_74779_i("recipe");
        this.recipe = recPath.isEmpty() ? null : new ResourceLocation(recPath);
        for (int i = 0; i < 19; ++i) {
            if (!nbt.func_74764_b("slot_" + i)) continue;
            this.inv[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("slot_" + i));
        }
        this.redstone = nbt.func_74767_n("reds");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 19; ++i) {
            if (this.inv[i].func_190926_b()) continue;
            nbt.func_218657_a("slot_" + i, (INBT)this.inv[i].func_77955_b(new CompoundNBT()));
        }
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", this.recipe.toString());
        }
        nbt.func_74757_a("reds", this.redstone);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", this.recipe.toString());
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.hanOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.hanOptional;
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        String str = nbt.func_74779_i("recipe");
        this.recipe = !str.isEmpty() ? new ResourceLocation(str) : null;
        if (!this.field_145850_b.field_72995_K) {
            this.setRecipe(this.getRecipeManager().func_215367_a(this.recipe).orElse(null));
        }
        this.func_70296_d();
    }

    public void setRecipe(@Nullable IRecipe<?> rec) {
        ResourceLocation resourceLocation = this.recipe = rec == null ? null : rec.func_199560_c();
        if (this.recipe != null) {
            for (int i = 10; i < 19; ++i) {
                this.inv[i] = ItemStack.field_190927_a;
                this.func_70296_d();
            }
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("recipe", this.recipe == null ? "" : this.recipe.toString());
        BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendNBTToClient(nbt, this.field_174879_c));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.auto_crafter");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new AutoCrafterContainer(id, playerInventory, this.iInv, this.recipe == null ? "" : this.recipe.toString(), this.field_174879_c);
    }

    public int getLegalSlots(Item item, IInventory inv) {
        int count;
        block3: {
            block2: {
                count = 0;
                if (this.recipe != null) break block2;
                for (int i = 10; i < 19; ++i) {
                    if (inv.func_70301_a(i).func_77973_b() != item) continue;
                    ++count;
                }
                break block3;
            }
            IRecipe<CraftingInventory> rec = AutoCrafterTileEntity.validateRecipe(this.recipe, this.getRecipeManager());
            if (rec == null) break block3;
            ItemStack testStack = new ItemStack((IItemProvider)item, 1);
            for (Ingredient ingr : rec.func_192400_c()) {
                if (!ingr.test(testStack)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getUsedSlots(Item item, IInventory inv) {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (inv.func_70301_a(i).func_77973_b() != item) continue;
            ++count;
        }
        return count;
    }

    public static class Inventory
    implements IInventory {
        private final ItemStack[] inv;
        @Nullable
        private final AutoCrafterTileEntity te;

        private Inventory(ItemStack[] inv, @Nullable AutoCrafterTileEntity te) {
            this.inv = inv;
            this.te = te;
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.inv.length ? ItemStack.field_190927_a : this.inv[index];
        }

        public ItemStack func_70298_a(int index, int count) {
            if (index >= this.inv.length || this.inv[index].func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            return this.inv[index].func_77979_a(count);
        }

        public ItemStack func_70304_b(int index) {
            if (index >= this.inv.length) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = this.inv[index].func_77946_l();
            this.inv[index].func_190920_e(0);
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (index < this.inv.length) {
                this.inv[index] = stack;
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            if (this.te != null) {
                this.te.func_70296_d();
            }
        }

        public boolean func_70300_a(PlayerEntity playerEntity) {
            return true;
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index < this.inv.length - 1;
        }

        public void func_174888_l() {
            Arrays.fill(this.inv, ItemStack.field_190927_a);
        }

        public boolean func_191420_l() {
            for (ItemStack itemStack : this.inv) {
                if (itemStack.func_190926_b()) continue;
                return false;
            }
            return true;
        }
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 10;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 10 ? AutoCrafterTileEntity.this.inv[slot] : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 9 || stack.func_190926_b()) {
                return stack;
            }
            Item item = stack.func_77973_b();
            if (AutoCrafterTileEntity.this.inv[slot].func_190926_b() && AutoCrafterTileEntity.this.getLegalSlots(item, AutoCrafterTileEntity.this.iInv) <= AutoCrafterTileEntity.this.getUsedSlots(item, AutoCrafterTileEntity.this.iInv)) {
                return stack;
            }
            if (!BlockUtil.sameItem(stack, AutoCrafterTileEntity.this.inv[slot]) && !AutoCrafterTileEntity.this.inv[slot].func_190926_b()) {
                return stack;
            }
            int change = Math.min(stack.func_77976_d() - AutoCrafterTileEntity.this.inv[slot].func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                if (AutoCrafterTileEntity.this.inv[slot].func_190926_b()) {
                    ((AutoCrafterTileEntity)AutoCrafterTileEntity.this).inv[slot] = stack.func_77946_l();
                } else {
                    AutoCrafterTileEntity.this.inv[slot].func_190917_f(change);
                }
            }
            ItemStack out = stack.func_77946_l();
            out.func_190918_g(change);
            return stack.func_190916_E() == change ? ItemStack.field_190927_a : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Item item;
            if (slot == 9 && !AutoCrafterTileEntity.this.inv[slot].func_190926_b()) {
                int change = Math.min(AutoCrafterTileEntity.this.inv[9].func_190916_E(), amount);
                ItemStack out = AutoCrafterTileEntity.this.inv[9].func_77946_l();
                out.func_190920_e(change);
                if (!simulate) {
                    AutoCrafterTileEntity.this.inv[9].func_190918_g(change);
                }
                return change == 0 ? ItemStack.field_190927_a : out;
            }
            if (slot < 9 && slot >= 0 && !AutoCrafterTileEntity.this.inv[slot].func_190926_b() && AutoCrafterTileEntity.this.getUsedSlots(item = AutoCrafterTileEntity.this.inv[slot].func_77973_b(), AutoCrafterTileEntity.this.iInv) > AutoCrafterTileEntity.this.getLegalSlots(item, AutoCrafterTileEntity.this.iInv)) {
                int change = Math.min(AutoCrafterTileEntity.this.inv[slot].func_190916_E(), amount);
                ItemStack out = AutoCrafterTileEntity.this.inv[slot].func_77946_l();
                out.func_190920_e(change);
                if (!simulate) {
                    AutoCrafterTileEntity.this.inv[slot].func_190918_g(change);
                }
                return change == 0 ? ItemStack.field_190927_a : out;
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot < 10 ? 64 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < 9;
        }
    }
}

