/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.packets.ILongReceiver;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface ILinkTE
extends ILongReceiver {
    public static final ITag<Item> LINKING_TOOLS = ItemTags.func_199901_a((String)new ResourceLocation("essentials", "linking_tool").toString());
    public static final String POS_NBT = "c_link";
    public static final String DIM_NBT = "c_link_dim";
    public static final byte LINK_PACKET_ID = 8;
    public static final byte CLEAR_PACKET_ID = 9;

    public static boolean isLinkTool(ItemStack stack) {
        return LINKING_TOOLS.func_230235_a_((Object)stack.func_77973_b());
    }

    public static AxisAlignedBB frustrum(ILinkTE te) {
        BlockPos pos = te.getTE().func_174877_v();
        int[] min = new int[3];
        int[] max = new int[3];
        for (BlockPos link : te.getLinks()) {
            min[0] = Math.min(min[0], link.func_177958_n());
            min[1] = Math.min(min[1], link.func_177956_o());
            min[2] = Math.min(min[2], link.func_177952_p());
            max[0] = Math.max(max[0], link.func_177958_n());
            max[1] = Math.max(max[1], link.func_177956_o());
            max[2] = Math.max(max[2], link.func_177952_p());
        }
        return new AxisAlignedBB((double)(min[0] + pos.func_177958_n()), (double)(min[1] + pos.func_177956_o()), (double)(min[2] + pos.func_177952_p()), (double)(max[0] + pos.func_177958_n() + 1), (double)(max[1] + pos.func_177956_o() + 1), (double)(max[2] + pos.func_177952_p() + 1));
    }

    default public TileEntity getTE() {
        return (TileEntity)this;
    }

    default public int getRange() {
        return 16;
    }

    public boolean canBeginLinking();

    public boolean canLink(ILinkTE var1);

    public Set<BlockPos> getLinks();

    default public int getMaxLinks() {
        return 3;
    }

    default public boolean link(ILinkTE endpoint, PlayerEntity player) {
        BlockPos linkPos;
        Set<BlockPos> links = this.getLinks();
        if (links.contains(linkPos = endpoint.getTE().func_174877_v().func_177973_b((Vector3i)this.getTE().func_174877_v()))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.taken"), player.func_110124_au());
        } else {
            if (links.size() < this.getMaxLinks()) {
                links.add(linkPos);
                BlockPos tePos = this.getTE().func_174877_v();
                BlockUtil.sendClientPacketAround(this.getTE().func_145831_w(), tePos, new SendLongToClient(8, linkPos.func_218275_a(), tePos));
                this.getTE().func_70296_d();
                player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.success", new Object[]{this.getTE().func_174877_v(), endpoint.getTE().func_174877_v()}), player.func_110124_au());
                return true;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.full", new Object[]{this.getMaxLinks()}), player.func_110124_au());
        }
        return false;
    }

    default public ItemStack wrench(ItemStack wrench, PlayerEntity player) {
        if (player.func_213453_ef()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.clear"), player.func_110124_au());
            this.clearLinks();
        } else if (wrench.func_77942_o() && wrench.func_77978_p().func_74764_b(POS_NBT) && wrench.func_77978_p().func_74779_i(DIM_NBT).equals(player.field_70170_p.func_234922_V_().func_240901_a_().toString())) {
            BlockPos prev = BlockPos.func_218283_e((long)wrench.func_77978_p().func_74763_f(POS_NBT));
            TileEntity te = player.field_70170_p.func_175625_s(prev);
            if (te instanceof ILinkTE && ((ILinkTE)te).canLink(this) && te != this) {
                if (prev.func_177951_i((Vector3i)this.getTE().func_174877_v()) <= (double)(((ILinkTE)te).getRange() * ((ILinkTE)te).getRange())) {
                    ((ILinkTE)te).link(this, player);
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.range"), player.func_110124_au());
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.invalid"), player.func_110124_au());
            }
        } else if (this.canBeginLinking()) {
            if (!wrench.func_77942_o()) {
                wrench.func_77982_d(new CompoundNBT());
            }
            wrench.func_77978_p().func_74772_a(POS_NBT, this.getTE().func_174877_v().func_218275_a());
            wrench.func_77978_p().func_74778_a(DIM_NBT, this.getTE().func_145831_w().func_234922_V_().func_240901_a_().toString());
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.start"), player.func_110124_au());
            return wrench;
        }
        if (wrench.func_77942_o()) {
            wrench.func_77978_p().func_82580_o(POS_NBT);
            wrench.func_77978_p().func_82580_o(DIM_NBT);
        }
        return wrench;
    }

    default public void clearLinks() {
        this.getLinks().clear();
        BlockPos tePos = this.getTE().func_174877_v();
        BlockUtil.sendClientPacketAround(this.getTE().func_145831_w(), tePos, new SendLongToClient(9, 0L, tePos));
    }
}

