/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.RedstoneReceiverTileEntity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

@ObjectHolder(value="essentials")
public class RedstoneTransmitterTileEntity
extends TileEntity
implements ILinkTE {
    @ObjectHolder(value="redstone_transmitter")
    public static TileEntityType<RedstoneTransmitterTileEntity> TYPE = null;
    private Set<BlockPos> linked = new HashSet<BlockPos>();
    private boolean builtConnections = false;
    private float output;
    private final LazyOptional<IRedstoneHandler> circOpt = LazyOptional.of(() -> new CircuitHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> circRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.circOpt);
    private ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> sources = new ArrayList(1);

    public RedstoneTransmitterTileEntity() {
        super(TYPE);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ILinkTE.frustrum(this);
    }

    @Override
    public boolean canBeginLinking() {
        return true;
    }

    public void dye(DyeColor color) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(ESProperties.COLOR) != color) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ESProperties.COLOR, (Comparable)color));
            for (BlockPos link : this.linked) {
                BlockPos worldLink = this.field_174879_c.func_177971_a((Vector3i)link);
                BlockState linkState = this.field_145850_b.func_180495_p(worldLink);
                if (linkState.func_177230_c() != ESBlocks.redstoneReceiver) continue;
                this.field_145850_b.func_175656_a(worldLink, (BlockState)linkState.func_206870_a(ESProperties.COLOR, (Comparable)color));
            }
        }
    }

    public float getOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        return this.output;
    }

    @Override
    public void clearLinks() {
        for (BlockPos linkPos : this.linked) {
            TileEntity te = this.field_145850_b.func_175625_s(linkPos);
            if (!(te instanceof RedstoneReceiverTileEntity)) continue;
            ((RedstoneReceiverTileEntity)te).setSrc(null);
        }
        this.linked.clear();
        this.func_70296_d();
        BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendLongToClient(9, 0L, this.field_174879_c));
    }

    public void buildConnections() {
        if (!this.field_145850_b.field_72995_K) {
            this.builtConnections = true;
            ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> preSrc = new ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>>(this.sources.size());
            preSrc.addAll(this.sources);
            this.sources.clear();
            for (Direction checkDir : Direction.values()) {
                IRedstoneHandler otherHandler;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(checkDir));
                if (te == null || (otherHandler = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.func_176734_d()))) == null) continue;
                otherHandler.requestSrc(this.circRef, 0, checkDir.func_176734_d(), checkDir);
            }
            if (this.sources.size() != preSrc.size() || !this.sources.containsAll(preSrc)) {
                this.field_145850_b.func_205220_G_().func_205362_a(this.field_174879_c, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.NORMAL);
            }
        }
    }

    public void refreshOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        float input = 0.0f;
        Direction[] sidesToCheck = Direction.values();
        for (int i = 0; i < this.sources.size(); ++i) {
            IRedstoneHandler handl;
            Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction> ref = this.sources.get(i);
            if (ref == null || (handl = (IRedstoneHandler)BlockUtil.get((LazyOptional)((WeakReference)ref.getLeft()).get())) == null) {
                this.sources.remove(i);
                --i;
                continue;
            }
            sidesToCheck[((Direction)ref.getRight()).func_176745_a()] = null;
            input = Math.max(input, RedstoneUtil.sanitize(handl.getOutput()));
        }
        for (Direction dir : sidesToCheck) {
            if (dir == null) continue;
            input = Math.max((float)RedstoneUtil.getRedstoneOnSide(this.field_145850_b, this.field_174879_c, dir), input);
        }
        if (RedstoneUtil.didChange(this.output, input = RedstoneUtil.sanitize(input))) {
            this.output = input;
            for (BlockPos link : this.linked) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)link));
                if (!(te instanceof RedstoneReceiverTileEntity)) continue;
                ((RedstoneReceiverTileEntity)te).notifyOutputChange();
            }
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.func_74772_a("link_" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.output = nbt.func_74760_g("out");
        int i = 0;
        while (nbt.func_74764_b("link_" + i)) {
            this.linked.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link_" + i)));
            ++i;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("out", this.output);
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.func_74772_a("link_" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    @Override
    public TileEntity getTE() {
        return this;
    }

    @Override
    public boolean canLink(ILinkTE otherTE) {
        return otherTE instanceof RedstoneReceiverTileEntity;
    }

    @Override
    public Set<BlockPos> getLinks() {
        return this.linked;
    }

    @Override
    public int getRange() {
        return (Integer)ESConfig.wirelessRange.get();
    }

    @Override
    public int getMaxLinks() {
        return 64;
    }

    @Override
    public boolean link(ILinkTE endpoint, PlayerEntity player) {
        BlockPos linkPos = endpoint.getTE().func_174877_v().func_177973_b((Vector3i)this.field_174879_c);
        if (this.linked.contains(linkPos)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.taken"), player.func_110124_au());
        } else {
            if (this.linked.size() < this.getMaxLinks()) {
                this.linked.add(linkPos);
                BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendLongToClient(8, linkPos.func_218275_a(), this.field_174879_c));
                this.getTE().func_70296_d();
                RedstoneReceiverTileEntity recTe = (RedstoneReceiverTileEntity)endpoint;
                recTe.setSrc(this.field_174879_c.func_177973_b((Vector3i)recTe.func_174877_v()));
                recTe.dye((DyeColor)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(ESProperties.COLOR));
                this.field_145850_b.func_190524_a(linkPos, (Block)ESBlocks.redstoneTransmitter, linkPos);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.success", new Object[]{this.getTE().func_174877_v(), endpoint.getTE().func_174877_v()}), player.func_110124_au());
                return true;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.full", new Object[]{this.getMaxLinks()}), player.func_110124_au());
        }
        return false;
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 8) {
            this.linked.add(BlockPos.func_218283_e((long)message));
        } else if (identifier == 9) {
            this.linked.clear();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.circOpt.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.circOpt;
        }
        return super.getCapability(cap, side);
    }

    private class CircuitHandler
    implements IRedstoneHandler {
        private CircuitHandler() {
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)src.get();
            if (srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get(srcOption);
                srcHandler.addDependent(RedstoneTransmitterTileEntity.this.circRef, nominalSide);
                Pair srcPair = Pair.of(src, (Object)fromSide);
                if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                    RedstoneTransmitterTileEntity.this.sources.add(srcPair);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
            Pair srcPair = Pair.of(src, (Object)fromSide);
            if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                RedstoneTransmitterTileEntity.this.sources.add(srcPair);
                this.notifyInputChange(src);
            }
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
            RedstoneTransmitterTileEntity.this.field_145850_b.func_205220_G_().func_205362_a(RedstoneTransmitterTileEntity.this.field_174879_c, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.HIGH);
        }
    }
}

