/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.init.ExoticBirdsTileEntities;
import net.pavocado.exoticbirds.item.ItemBirdcage;
import net.pavocado.exoticbirds.tileentity.BirdcageLogic;
import net.pavocado.exoticbirds.tileentity.TileEntityBirdcage;

public class BlockBirdcage
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final VoxelShape CAGE_SHAPE = Block.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)14.0, (double)13.5);

    public BlockBirdcage(Block.Properties blockPropertiesIn) {
        super(blockPropertiesIn);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return CAGE_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CAGE_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CAGE_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)ExoticBirdsTileEntities.BIRDCAGE.get()).func_200968_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity entity;
        if (stack.func_77973_b() instanceof ItemBirdcage && ItemBirdcage.containsData(stack) && (entity = worldIn.func_175625_s(pos)) instanceof TileEntityBirdcage) {
            ((TileEntityBirdcage)entity).getBirdcageLogic().setEntityData(ItemBirdcage.getCageData(stack));
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityBirdcage) {
            BirdcageLogic birdcagelogic = ((TileEntityBirdcage)tileentity).getBirdcageLogic();
            birdcagelogic.spawnEntity(explosionIn);
        }
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityBirdcage) {
            BirdcageLogic birdcagelogic = ((TileEntityBirdcage)tileentity).getBirdcageLogic();
            ItemStack itemstack = new ItemStack((IItemProvider)Item.func_150898_a((Block)this));
            if (!player.func_70093_af() || player.field_71075_bZ.field_75098_d) {
                birdcagelogic.spawnEntity();
                if (!player.field_71075_bZ.field_75098_d) {
                    BlockBirdcage.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
                }
            } else {
                CompoundNBT cageData = birdcagelogic.getEntityData();
                if (cageData != null) {
                    itemstack.func_77983_a("EntityData", (INBT)cageData);
                }
                BlockBirdcage.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            }
        }
    }
}

