/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.client.gui.CachedEntry;
import net.pavocado.exoticbirds.client.gui.buttons.BirdVariantButton;
import net.pavocado.exoticbirds.client.gui.buttons.ChildBirdButton;
import net.pavocado.exoticbirds.client.gui.buttons.EntityTypeButton;
import net.pavocado.exoticbirds.client.gui.buttons.RotateBirdButton;
import net.pavocado.exoticbirds.client.gui.buttons.SmallArrowButton;
import net.pavocado.exoticbirds.client.gui.buttons.ToggleSpinBirdButton;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBirdBook
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("exoticbirds:textures/gui/birdbook.png");
    private TextFieldWidget searchField;
    private RotateBirdButton buttonLeft;
    private RotateBirdButton buttonRight;
    private ToggleSpinBirdButton buttonSpin;
    private ChildBirdButton buttonToggleChild;
    private SmallArrowButton biomeScrollLeft;
    private SmallArrowButton biomeScrollRight;
    private SmallArrowButton tamedItemsScrollLeft;
    private SmallArrowButton tamedItemsScrollRight;
    private SmallArrowButton bredItemsScrollLeft;
    private SmallArrowButton bredItemsScrollRight;
    private List<EntityTypeButton> entityTypeButtons;
    private List<BirdVariantButton> birdVariantButtons;
    public static Set<Pair<EntityType, Integer>> trackedBirds = new HashSet<Pair<EntityType, Integer>>();
    private List<EntityType> searchedBirdList = Lists.newArrayList();
    public CachedEntry cachedEntry;
    private int rotateAngle;
    private int bredItemIndex;
    private int tamedItemIndex;
    private int biomeListIndex;
    private boolean autoRotate = false;
    private ItemStack hoveredItemStack;
    private float currentMainScroll;
    private float currentSideScroll;
    private boolean isMainScrolling;
    private boolean isSideScrolling;
    private int xSize = 256;
    private int ySize = 166;

    public ScreenBirdBook(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        if (player != null) {
            player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                trackedBirds = cap.getAll();
            });
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.setFocused(null);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.blit(x, y, 0, 0, this.xSize, this.ySize);
        this.blit(x + 69, (int)((float)(y + 22) + 122.0f * this.currentMainScroll), this.searchedBirdList.size() > this.entityTypeButtons.size() ? 0 : 9, 220, 9, 13);
        this.blit(x + 240, (int)((float)(y + 96) + 47.0f * this.currentSideScroll), this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size() ? 0 : 9, 233, 9, 13);
        this.searchField.render(mouseX, mouseY, partialTicks);
        this.hoveredItemStack = null;
        if (this.cachedEntry != null) {
            CachedEntry.BirdVariantEntry currentVariant;
            EntityAbstractBird birdEntity = this.cachedEntry.getCachedEntity();
            birdEntity.field_70122_E = true;
            this.font.func_211126_b(birdEntity.func_145748_c_().func_150254_d(), (float)(x + 96), (float)(y + 8), 0);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.font.func_211126_b(this.cachedEntry.getFamilyName(), (float)((x + 96) * 2), (float)((y + 17) * 2), 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.variant_count", (Object[])new Object[]{this.cachedEntry.getDiscoveredVariants(), this.cachedEntry.getBirdVariantList().size()}), (float)((x + 96) * 2), (float)((y + 23) * 2), 0x404040);
            this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.egg", (Object[])new Object[0]), (float)((x + 96) * 2), (float)((y + 36) * 2), 0);
            this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.breeding_items", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 36) * 2), 0);
            this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.taming_items", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 57) * 2), 0);
            this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.biomes", (Object[])new Object[0]), (float)((x + 96) * 2), (float)((y + 77) * 2), 0);
            GlStateManager.popMatrix();
            float f = 2.0f;
            float f1 = Math.max(birdEntity.func_213311_cf(), birdEntity.func_213302_cg());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            if (!(currentVariant = this.cachedEntry.getCurrentVariant()).isVariantUnlocked()) {
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.drawEntityOnScreen(x + 215, y + 70, (int)(f * 20.0f), x + 180 - mouseX, y + 45 - 30 - mouseY, (LivingEntity)birdEntity);
            if (currentVariant.getVariantName().length() > 0) {
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.drawCenteredString(this.font, currentVariant.getVariantName(), (x + 216) * 2, (y + 15) * 2, 0xFFFFFF);
                if (birdEntity.func_70631_g_()) {
                    this.drawCenteredString(this.font, I18n.func_135052_a((String)"book.exoticbirds.child", (Object[])new Object[0]), (x + 216) * 2, (y + 21) * 2, 0xFFFFFF);
                }
                GlStateManager.popMatrix();
            }
            List<ItemStack> breedingItems = this.cachedEntry.getBreedingItems();
            for (int i = 0; i < 4; ++i) {
                if (i + this.bredItemIndex >= breedingItems.size()) continue;
                this.drawItemStack(breedingItems.get(i + this.bredItemIndex), x + 124 + i * 14, y + 40);
                if (!this.isItemSelected(x + 124 + i * 14, y + 40, 16, mouseX, mouseY)) continue;
                this.hoveredItemStack = breedingItems.get(i + this.bredItemIndex);
            }
            if (breedingItems.size() == 0) {
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.font.func_211126_b("\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.cannot_breed", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 43) * 2), 0x404040);
                GlStateManager.popMatrix();
            }
            List<ItemStack> tamingItems = this.cachedEntry.getTamingItems();
            for (int i = this.tamedItemIndex; i < 4; ++i) {
                if (i + this.tamedItemIndex >= tamingItems.size()) continue;
                this.drawItemStack(tamingItems.get(i + this.tamedItemIndex), x + 124 + i * 14, y + 61);
                if (!this.isItemSelected(x + 124 + i * 14, y + 61, 16, mouseX, mouseY)) continue;
                this.hoveredItemStack = tamingItems.get(i + this.tamedItemIndex);
            }
            if (tamingItems.size() == 0) {
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.font.func_211126_b("\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.cannot_tame", (Object[])new Object[0]), (float)((x + 127) * 2), (float)((y + 64) * 2), 0x404040);
                GlStateManager.popMatrix();
            }
            List<Biome> biomeList = this.cachedEntry.getBiomeList();
            for (int i = 0; i < 15; ++i) {
                Biome currentBiome;
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (biomeList.size() <= 15) {
                    if (i < biomeList.size()) {
                        currentBiome = biomeList.get(i);
                        this.font.func_211126_b(currentBiome.func_205403_k().func_150254_d(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    } else if (biomeList.size() == 0) {
                        this.font.func_211126_b("\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.no_biomes", (Object[])new Object[0]), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                    }
                } else if (this.biomeListIndex == 0) {
                    if (i < 14) {
                        currentBiome = biomeList.get(i);
                        this.font.func_211126_b(currentBiome.func_205403_k().func_150254_d(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    } else {
                        this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.more_items", (Object[])new Object[]{biomeList.size() - 14}), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    }
                } else if (biomeList.size() <= 28 + (this.biomeListIndex - 1) * 13) {
                    if (i == 0) {
                        this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.previous_items", (Object[])new Object[]{14 + 13 * (this.biomeListIndex - 1)}), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                    } else if (i - 1 + (14 + 13 * (this.biomeListIndex - 1)) < biomeList.size()) {
                        currentBiome = biomeList.get(i - 1 + (14 + 13 * (this.biomeListIndex - 1)));
                        this.font.func_211126_b(currentBiome.func_205403_k().func_150254_d(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                    }
                } else if (i == 0) {
                    this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.previous_items", (Object[])new Object[]{14 + 13 * (this.biomeListIndex - 1)}), (float)((x + 98) * 2), (float)((y + 83) * 2), 0x404040);
                } else if (i == 14) {
                    this.font.func_211126_b(I18n.func_135052_a((String)"book.exoticbirds.more_items", (Object[])new Object[]{14 + 13 * this.biomeListIndex}), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                } else if (i - 1 + (14 + 13 * (this.biomeListIndex - 1)) < biomeList.size()) {
                    currentBiome = biomeList.get(i - 1 + (14 + 13 * (this.biomeListIndex - 1)));
                    this.font.func_211126_b(currentBiome.func_205403_k().func_150254_d(), (float)((x + 98) * 2), (float)((y + 83 + i * 5) * 2), 0x404040);
                }
                GlStateManager.popMatrix();
            }
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.drawItemStack(this.cachedEntry.getBirdEgg(), (x + 94) / 2, (y + 40) / 2);
            GlStateManager.popMatrix();
        }
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        this.renderHoveredToolTip(mouseX, mouseY);
    }

    private boolean isItemSelected(int topLeft, int topRight, int size, double mouseX, double mouseY) {
        return mouseX >= (double)(topLeft - 1) && mouseX < (double)(topLeft + size + 1) && mouseY >= (double)(topRight - 1) && mouseY < (double)(topRight + size + 1);
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.buttonLeft = (RotateBirdButton)this.addButton((Widget)new RotateBirdButton(x + 190, y + 76, true, button -> {
            this.rotateAngle += 45;
            this.rotateAngle = MathHelper.func_188209_b((int)this.rotateAngle);
        }));
        this.buttonRight = (RotateBirdButton)this.addButton((Widget)new RotateBirdButton(x + 232, y + 76, false, button -> {
            this.rotateAngle -= 45;
            this.rotateAngle = MathHelper.func_188209_b((int)this.rotateAngle);
        }));
        this.buttonSpin = (ToggleSpinBirdButton)this.addButton((Widget)new ToggleSpinBirdButton(x + 203, y + 77, button -> {
            boolean bl = this.autoRotate = !this.autoRotate;
            if (this.autoRotate) {
                button.setMessage(I18n.func_135052_a((String)"book.exoticbirds.button.pause", (Object[])new Object[0]));
            } else {
                button.setMessage(I18n.func_135052_a((String)"book.exoticbirds.button.spin", (Object[])new Object[0]));
            }
        }));
        this.buttonToggleChild = (ChildBirdButton)this.addButton((Widget)new ChildBirdButton(x + 163, y + 10, button -> {
            EntityAbstractBird entity;
            if (this.cachedEntry != null && (entity = this.cachedEntry.getCachedEntity()) != null) {
                if (entity.func_70631_g_()) {
                    entity.func_70873_a(0);
                } else {
                    entity.func_70873_a(-24000);
                }
            }
        }));
        this.biomeScrollLeft = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 167, y + 77, true, button -> {
            this.biomeListIndex = MathHelper.func_76125_a((int)(--this.biomeListIndex), (int)0, (int)MathHelper.func_76123_f((float)(this.cachedEntry.getBiomeList().size() / 13)));
            this.biomeScrollLeft.visible = this.biomeListIndex > 0;
            this.biomeScrollRight.visible = true;
        }));
        this.biomeScrollRight = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 175, y + 77, false, button -> {
            this.biomeListIndex = MathHelper.func_76125_a((int)(++this.biomeListIndex), (int)0, (int)MathHelper.func_76123_f((float)(this.cachedEntry.getBiomeList().size() / 13)));
            this.biomeScrollRight.visible = this.cachedEntry.getBiomeList().size() > 15 + this.biomeListIndex * 13 + (this.biomeListIndex > 0 ? 1 : 0);
            this.biomeScrollLeft.visible = true;
        }));
        this.tamedItemsScrollLeft = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 167, y + 54, true, button -> {
            this.tamedItemIndex = MathHelper.func_76125_a((int)(--this.tamedItemIndex), (int)0, (int)(this.cachedEntry.getTamingItems().size() - 4));
            this.tamedItemsScrollLeft.visible = this.tamedItemIndex > 0;
            this.tamedItemsScrollRight.visible = true;
        }));
        this.tamedItemsScrollRight = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 175, y + 54, false, button -> {
            this.tamedItemIndex = MathHelper.func_76125_a((int)(++this.tamedItemIndex), (int)0, (int)(this.cachedEntry.getTamingItems().size() - 4));
            this.tamedItemsScrollRight.visible = this.tamedItemIndex < this.cachedEntry.getTamingItems().size() - 4;
            this.tamedItemsScrollLeft.visible = true;
        }));
        this.bredItemsScrollLeft = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 167, y + 33, true, button -> {
            this.bredItemIndex = MathHelper.func_76125_a((int)(--this.bredItemIndex), (int)0, (int)(this.cachedEntry.getBreedingItems().size() - 4));
            this.bredItemsScrollLeft.visible = this.bredItemIndex > 0;
            this.bredItemsScrollRight.visible = true;
        }));
        this.bredItemsScrollRight = (SmallArrowButton)this.addButton((Widget)new SmallArrowButton(x + 175, y + 33, false, button -> {
            this.bredItemIndex = MathHelper.func_76125_a((int)(++this.bredItemIndex), (int)0, (int)(this.cachedEntry.getBreedingItems().size() - 4));
            this.bredItemsScrollRight.visible = this.bredItemIndex < this.cachedEntry.getBreedingItems().size() - 4;
            this.bredItemsScrollLeft.visible = true;
        }));
        ArrayList tempEntityTypeButtons = Lists.newArrayList();
        for (int i = 0; i < 9; ++i) {
            EntityTypeButton birdButton = (EntityTypeButton)this.addButton((Widget)new EntityTypeButton(x + 6, y + 22 + i * 15, button -> this.updatePageInfo(((EntityTypeButton)button).getEntityType())));
            tempEntityTypeButtons.add(birdButton);
        }
        this.entityTypeButtons = tempEntityTypeButtons;
        ArrayList tempBirdVariantButtons = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            BirdVariantButton birdButton = (BirdVariantButton)this.addButton((Widget)new BirdVariantButton(x + 184, y + 96 + i * 12, button -> {
                if (this.cachedEntry != null) {
                    this.cachedEntry.setCurrentVariant(((BirdVariantButton)button).getVariantEntry());
                }
            }));
            tempBirdVariantButtons.add(birdButton);
        }
        this.birdVariantButtons = tempBirdVariantButtons;
        this.tamedItemsScrollLeft.visible = false;
        this.tamedItemsScrollRight.visible = false;
        this.bredItemsScrollLeft.visible = false;
        this.bredItemsScrollRight.visible = false;
        this.biomeScrollLeft.visible = false;
        this.biomeScrollRight.visible = false;
        this.font.getClass();
        this.searchField = new TextFieldWidget(this.font, x + 9, y + 9, 69, 9, I18n.func_135052_a((String)"itemGroup.search", (Object[])new Object[0]));
        this.searchField.func_146203_f(20);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.children.add(this.searchField);
        this.updateBirdSearch();
        if (this.searchedBirdList.size() > 0) {
            this.updatePageInfo(this.searchedBirdList.get(0));
        }
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void tick() {
        super.tick();
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
        if (this.autoRotate) {
            this.rotateAngle = MathHelper.func_188209_b((int)(this.rotateAngle += 5));
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.searchField.func_146179_b();
        CachedEntry entry = this.cachedEntry;
        int rotateAngle = this.rotateAngle;
        boolean autoRotate = this.autoRotate;
        this.init(minecraft, width, height);
        this.searchField.func_146180_a(s);
        if (!this.searchField.func_146179_b().isEmpty()) {
            this.updateBirdSearch();
        }
        if (entry != null) {
            this.updatePageInfo(entry);
        }
        this.rotateAngle = rotateAngle;
        this.autoRotate = autoRotate;
    }

    public boolean charTyped(char charIn, int keyCode) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.charTyped(charIn, keyCode)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.currentMainScroll = 0.0f;
                this.updateBirdSearch();
            }
            return true;
        }
        return keyCode != 256 || super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateBirdSearch() {
        this.searchedBirdList.clear();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (EntityType entityType : Registry.field_212629_r) {
            if (!TextFormatting.func_110646_a((String)I18n.func_135052_a((String)entityType.func_210760_d(), (Object[])new Object[0])).toLowerCase().contains(s1) || !(entityType.func_200721_a((World)this.minecraft.field_71441_e) instanceof EntityAbstractBird)) continue;
            this.searchedBirdList.add(entityType);
        }
        Collections.sort(this.searchedBirdList, new Comparator<EntityType>(){

            @Override
            public int compare(EntityType first, EntityType second) {
                return I18n.func_135052_a((String)first.func_210760_d(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)second.func_210760_d(), (Object[])new Object[0]));
            }
        });
        this.updateEntityTypeButtons();
    }

    public void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity ent) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)50.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = this.rotateAngle;
        ent.field_70177_z = this.rotateAngle;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        entityrenderermanager.func_178631_a(180.0f);
        entityrenderermanager.func_178633_a(false);
        entityrenderermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entityrenderermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    private void renderHoveredToolTip(int mouseX, int mouseY) {
        if (this.hoveredItemStack != null && !this.hoveredItemStack.func_190926_b()) {
            this.renderTooltip(this.hoveredItemStack, mouseX, mouseY);
        }
    }

    private void updateEntityTypeButtons() {
        for (EntityTypeButton button : this.entityTypeButtons) {
            button.setEntityType(null);
            button.visible = false;
        }
        for (int i = 0; i < MathHelper.func_76125_a((int)this.searchedBirdList.size(), (int)0, (int)this.entityTypeButtons.size()); ++i) {
            EntityTypeButton button;
            button = this.entityTypeButtons.get(i);
            int birdIndex = i + MathHelper.func_76125_a((int)((int)(this.currentMainScroll * (float)(this.searchedBirdList.size() - this.entityTypeButtons.size()))), (int)0, (int)this.searchedBirdList.size());
            button.setEntityType(this.searchedBirdList.get(birdIndex));
            button.visible = true;
        }
    }

    private void updateVariantButtons() {
        for (BirdVariantButton button : this.birdVariantButtons) {
            button.setVariantInfo(null);
            button.visible = false;
        }
        if (this.cachedEntry != null) {
            List<CachedEntry.BirdVariantEntry> birdVariantList = this.cachedEntry.getBirdVariantList();
            for (int i = 0; i < MathHelper.func_76125_a((int)birdVariantList.size(), (int)0, (int)this.birdVariantButtons.size()); ++i) {
                BirdVariantButton button = this.birdVariantButtons.get(i);
                int birdIndex = i + MathHelper.func_76125_a((int)((int)(this.currentSideScroll * (float)(birdVariantList.size() - this.birdVariantButtons.size()))), (int)0, (int)birdVariantList.size());
                button.setVariantInfo(birdVariantList.get(birdIndex));
                button.visible = true;
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.inMainScrollbar(mouseX, mouseY)) {
                this.isMainScrolling = true;
                return true;
            }
            if (this.inSideScrollbar(mouseX, mouseY)) {
                this.isSideScrolling = true;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isMainScrolling = false;
            this.isSideScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int x = (this.width - this.xSize) / 2;
        if (mouseX - (double)x < 84.0 && this.searchedBirdList.size() > this.entityTypeButtons.size()) {
            int i = this.searchedBirdList.size() - this.entityTypeButtons.size();
            this.currentMainScroll = (float)((double)this.currentMainScroll - amount / (double)i);
            this.currentMainScroll = MathHelper.func_76131_a((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateEntityTypeButtons();
            return true;
        }
        if (mouseX - (double)x > 84.0 && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = this.cachedEntry.getBirdVariantList().size() - this.birdVariantButtons.size();
            this.currentSideScroll = (float)((double)this.currentSideScroll - amount / (double)i);
            this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        int y = (this.height - this.ySize) / 2;
        if (this.isMainScrolling && this.searchedBirdList.size() > this.entityTypeButtons.size()) {
            int i = y + 22;
            this.currentMainScroll = ((float)mouseY - (float)i - 7.5f) / 121.0f;
            this.currentMainScroll = MathHelper.func_76131_a((float)this.currentMainScroll, (float)0.0f, (float)1.0f);
            this.updateEntityTypeButtons();
            return true;
        }
        if (this.isSideScrolling && this.cachedEntry != null && this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size()) {
            int i = y + 96;
            this.currentSideScroll = ((float)mouseY - (float)i - 7.5f) / 46.0f;
            this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            this.updateVariantButtons();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    private boolean inMainScrollbar(double mouseX, double mouseY) {
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int i = x + 69;
        int j = y + 22;
        int k = i + 9;
        int l = j + 136;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private boolean inSideScrollbar(double mouseX, double mouseY) {
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int i = x + 237;
        int j = y + 96;
        int k = i + 9;
        int l = j + 135;
        return mouseX >= (double)i && mouseY >= (double)j && mouseX < (double)k && mouseY < (double)l;
    }

    private void updatePageInfo(CachedEntry cachedEntry) {
        this.cachedEntry = cachedEntry;
        this.currentSideScroll = 0.0f;
        this.bredItemIndex = 0;
        this.tamedItemIndex = 0;
        this.biomeListIndex = 0;
        if (!this.autoRotate) {
            this.rotateAngle = 45;
        }
        if (this.cachedEntry != null) {
            int variantIndex;
            this.biomeScrollRight.visible = this.cachedEntry.getBiomeList().size() > 15;
            this.biomeScrollLeft.visible = false;
            this.bredItemsScrollRight.visible = this.cachedEntry.getBreedingItems().size() > 4;
            this.bredItemsScrollLeft.visible = false;
            this.tamedItemsScrollRight.visible = this.cachedEntry.getTamingItems().size() > 4;
            this.tamedItemsScrollLeft.visible = false;
            if (this.cachedEntry.getBirdVariantList().size() > this.birdVariantButtons.size() && (variantIndex = this.cachedEntry.getBirdVariantList().indexOf(this.cachedEntry.getCurrentVariant())) > 4) {
                this.currentSideScroll = 1 - variantIndex / this.cachedEntry.getBirdVariantList().size();
                this.currentSideScroll = MathHelper.func_76131_a((float)this.currentSideScroll, (float)0.0f, (float)1.0f);
            }
        }
        this.updateVariantButtons();
    }

    private void updatePageInfo(EntityType selectedBirdType) {
        this.updateCachedEntity(selectedBirdType);
        this.updatePageInfo(this.cachedEntry);
    }

    private void updateCachedEntity(EntityType selectedBirdType) {
        Entity entity;
        this.cachedEntry = null;
        if (selectedBirdType != null && (entity = selectedBirdType.func_200721_a((World)this.minecraft.field_71441_e)) instanceof EntityAbstractBird) {
            this.cachedEntry = new CachedEntry((EntityAbstractBird)entity);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        this.blitOffset = 100;
        this.itemRenderer.field_77023_b = 100.0f;
        GlStateManager.enableLighting();
        GlStateManager.enableRescaleNormal();
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_175030_a(this.font, stack, x, y);
        GlStateManager.disableLighting();
        this.itemRenderer.field_77023_b = 0.0f;
        this.blitOffset = 0;
        GlStateManager.popMatrix();
    }

    public static boolean isEntityUnlocked(EntityType entityType, int variant) {
        for (Pair<EntityType, Integer> pair : trackedBirds) {
            if (pair.getKey() != entityType || (Integer)pair.getValue() != variant) continue;
            return true;
        }
        return false;
    }
}

