/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.client.gui.CachedEntry;
import net.pavocado.exoticbirds.client.gui.ScreenBirdBook;

@OnlyIn(value=Dist.CLIENT)
public class BirdVariantButton
extends Button {
    private CachedEntry.BirdVariantEntry variantEntry;
    int startIndex = 0;
    int endIndex = 16;
    float scrollAmount = 0.0f;
    boolean forwards = true;

    public BirdVariantButton(int xIn, int yIn, Button.IPressable onPress) {
        super(xIn, yIn, 53, 12, "", onPress);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ScreenBirdBook.BACKGROUND);
        int i = 145;
        int j = 166;
        if (this.isHovered()) {
            j += this.height;
        }
        this.blit(this.x, this.y, i, j, this.width, this.height);
        int k = this.getFGColor();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        String variantName = this.getMessage();
        if (variantName.length() > 16) {
            this.scrollAmount += partialTicks;
            if (this.scrollAmount > 8.0f) {
                this.scrollAmount -= 8.0f;
                if (this.forwards) {
                    ++this.startIndex;
                    ++this.endIndex;
                } else {
                    --this.startIndex;
                    --this.endIndex;
                }
                if (this.endIndex == variantName.length() || this.startIndex == 0) {
                    this.forwards = !this.forwards;
                }
            }
            variantName = variantName.substring(Math.max(this.startIndex, 0), Math.min(this.endIndex, variantName.length()));
        }
        this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, variantName, this.x * 2 + (this.width + 53) / 2, this.y * 2 + (this.height + 6) / 2, k | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        GlStateManager.popMatrix();
    }

    public void setVariantInfo(CachedEntry.BirdVariantEntry birdVariant) {
        this.startIndex = 0;
        this.endIndex = 16;
        this.scrollAmount = 0.0f;
        this.forwards = true;
        this.variantEntry = birdVariant;
        this.setMessage("???");
        if (birdVariant != null && birdVariant.isVariantUnlocked()) {
            this.setMessage(birdVariant.getVariantName());
        }
    }

    public CachedEntry.BirdVariantEntry getVariantEntry() {
        return this.variantEntry;
    }
}

