/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.client.model.ModelBirdcage;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.item.ItemBirdcage;
import net.pavocado.exoticbirds.tileentity.BirdcageLogic;
import net.pavocado.exoticbirds.tileentity.TileEntityBirdcage;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityBirdcageRenderer
extends TileEntityRenderer<TileEntityBirdcage> {
    public static TileEntityBirdcageRenderer instance;
    private final ModelBirdcage model = new ModelBirdcage();

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        super.func_147497_a(rendererDispatcherIn);
        instance = this;
    }

    public void render(TileEntityBirdcage tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        Direction facing = (Direction)tileEntityIn.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        int rotation = 0;
        if (facing == Direction.NORTH) {
            rotation = 180;
        } else if (facing == Direction.SOUTH) {
            rotation = 0;
        } else if (facing == Direction.WEST) {
            rotation = -90;
        } else if (facing == Direction.EAST) {
            rotation = 90;
        }
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderMob(tileEntityIn.getBirdcageLogic(), x, y, z, partialTicks);
        GlStateManager.popMatrix();
    }

    public void renderItem(ItemStack itemStack) {
        this.func_147499_a(new ResourceLocation("exoticbirds", "textures/entity/birdcage/" + itemStack.func_77973_b().func_77658_a().substring(7 + "exoticbirds".length()) + ".png"));
        this.renderCage();
        if (itemStack.func_77973_b() instanceof ItemBirdcage && ItemBirdcage.containsData(itemStack)) {
            BirdcageLogic birdcageLogic = new BirdcageLogic(){

                @Override
                public World getWorld() {
                    return Minecraft.func_71410_x().field_71441_e;
                }

                @Override
                public BlockPos getCagePosition() {
                    return null;
                }
            };
            birdcageLogic.setEntityData(ItemBirdcage.getCageData(itemStack));
            Entity entity = birdcageLogic.getCachedEntity();
            if (entity instanceof EntityAbstractBird) {
                float f = 0.43125f;
                float f1 = Math.max(entity.func_213311_cf(), entity.func_213302_cg());
                if ((double)f1 > 1.0) {
                    f /= f1;
                }
                GlStateManager.enableColorMaterial();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.5f, (float)0.45f, (float)0.5f);
                GlStateManager.scalef((float)f, (float)f, (float)f);
                EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
                entityrenderermanager.func_178631_a(180.0f);
                entityrenderermanager.func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
                GlStateManager.popMatrix();
                GlStateManager.disableRescaleNormal();
                GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
                GlStateManager.disableTexture();
                GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
            }
        }
    }

    public void renderMob(BirdcageLogic birdcageLogic, double posX, double posY, double posZ, float partialTicks) {
        Entity cachedEntity = birdcageLogic.getCachedEntity();
        if (cachedEntity instanceof EntityAbstractBird) {
            EntityAbstractBird entity = (EntityAbstractBird)cachedEntity;
            float f = 0.43125f;
            float f1 = Math.max(entity.func_213311_cf(), entity.func_213302_cg());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            GlStateManager.translatef((float)0.0f, (float)0.35f, (float)0.0f);
            GlStateManager.scalef((float)f, (float)f, (float)f);
            entity.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
            entity.field_70759_as = (float)birdcageLogic.getMobRotation();
            entity.field_70758_at = (float)birdcageLogic.getPrevMobRotation();
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
        }
    }

    private void renderCage() {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)-0.5f, (float)0.55f, (float)0.5f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(180.0f + Direction.SOUTH.func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.enableRescaleNormal();
        this.model.render();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }
}

