/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.AI.FlyingBirdTemptGoal;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class EntityHummingbird
extends EntityAbstractBird {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_blue.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_green.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_purple.png"));
        hashMap.put(3, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_red.png"));
        hashMap.put(4, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_yellow.png"));
    });

    public EntityHummingbird(EntityType<? extends EntityHummingbird> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.HUMMINGBIRD_EGG.get()), BIRD_TEXTURES.size(), false, false);
        this.field_70765_h = new FlyingBirdMovementController((MobEntity)this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(1.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsHummingbird;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingBirdTemptGoal((CreatureEntity)this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new WanderGoal());
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return ExoticBirdsEntities.FLYING_BIRD;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.field_70146_Z.nextInt(this.numberOfTypes));
        return spawnDataIn;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70122_E && this.wingRotDelta < 1.0f && !this.field_70171_ac) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    @Override
    public int getChildVariant() {
        return this.field_70146_Z.nextInt(this.numberOfTypes);
    }

    public EntityHummingbird createChild(AgeableEntity ageable) {
        EntityHummingbird entityHummingbird = new EntityHummingbird((EntityType<? extends EntityHummingbird>)((EntityType)ExoticBirdsEntities.HUMMINGBIRD.get()), this.field_70170_p);
        entityHummingbird.setVariant(this.getChildVariant());
        return entityHummingbird;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151102_aT;
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityHummingbird.this.field_70699_by.func_75500_f() && EntityHummingbird.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return !EntityHummingbird.this.field_70699_by.func_75500_f();
        }

        public void func_75249_e() {
            Vec3d vec3d = this.getTargetPosition();
            if (vec3d != null) {
                EntityHummingbird.this.field_70699_by.func_75484_a(EntityHummingbird.this.field_70699_by.func_179680_a(new BlockPos(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3d getTargetPosition() {
            Vec3d vec3d = EntityHummingbird.this.func_70676_i(0.0f);
            Vec3d vec3d2 = RandomPositionGenerator.func_221024_a((CreatureEntity)EntityHummingbird.this, (int)8, (int)7, arg_0 -> ((EntityHummingbird)EntityHummingbird.this).func_180484_a(arg_0));
            return vec3d2 != null ? vec3d2 : vec3d;
        }
    }

    public class FlyingBirdMovementController
    extends FlyingMovementController {
        public FlyingBirdMovementController(MobEntity p_i47418_1_) {
            super(p_i47418_1_);
        }

        public void func_75641_c() {
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_189654_d(true);
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                super.func_75641_c();
            }
        }
    }
}

