/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSounds;

public class EntityPeafowl
extends EntityAbstractBird {
    private static final DataParameter<Boolean> TRAIN_OPEN = EntityDataManager.func_187226_a(EntityPeafowl.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_male.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_female.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/peafowl/peafowl_indian_white.png"));
    });
    private int trainTimer;

    public EntityPeafowl(EntityType<? extends EntityPeafowl> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.PEAFOWL_EGG.get()), BIRD_TEXTURES.size(), true, true);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.hasChildTextures = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRAIN_OPEN, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public EntityAbstractBird.Gender getGender(int variant) {
        return variant == 2 ? EntityAbstractBird.Gender.NONE : super.getGender(variant);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsPeafowl;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_PEAFOWL_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_PEAFOWL_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityPeafowl createChild(AgeableEntity ageable) {
        EntityPeafowl entityPeafowl = new EntityPeafowl((EntityType<? extends EntityPeafowl>)((EntityType)ExoticBirdsEntities.PEAFOWL.get()), this.field_70170_p);
        entityPeafowl.setVariant(this.getChildVariant());
        return entityPeafowl;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.9f;
    }

    public boolean getTrainOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(TRAIN_OPEN);
    }

    public void setTrainOpen(boolean setOpen) {
        this.field_70180_af.func_187227_b(TRAIN_OPEN, (Object)setOpen);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setTrainOpen(compound.func_74767_n("TrainOpen"));
        this.trainTimer = compound.func_74762_e("TrainTime");
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("TrainOpen", this.getTrainOpen());
        compound.func_74768_a("TrainTime", this.trainTimer);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.trainTimer > 0) {
            --this.trainTimer;
            if (this.trainTimer <= 0 && this.getTrainOpen()) {
                this.setTrainOpen(false);
                this.func_184185_a(SoundEvents.field_187867_gJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    void openTrain() {
        if (!this.getTrainOpen() && this.getVariant() % 2 == 0) {
            this.setTrainOpen(true);
            this.func_184185_a(SoundEvents.field_187867_gJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.trainTimer = 500 + this.field_70146_Z.nextInt(100);
        }
    }

    public void func_146082_f(@Nullable PlayerEntity player) {
        super.func_146082_f(player);
        this.openTrain();
    }

    public void func_204700_e(int ticks) {
        super.func_204700_e(ticks);
        this.openTrain();
    }

    @Override
    public int getChildVariant() {
        if (this.getVariant() == 2 || this.field_70146_Z.nextInt(80) == 0) {
            return 2;
        }
        return super.getChildVariant();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData livingData = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.field_70146_Z.nextInt(80) == 0) {
            this.setVariant(2);
        } else {
            this.setVariant(this.field_70146_Z.nextInt(2));
        }
        return livingData;
    }
}

