/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSounds;

public class EntityPenguin
extends EntityAbstractBird {
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/penguin/penguin_emperor.png")));
    public float penguinPitch;
    public float prevPenguinPitch;
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;

    public EntityPenguin(EntityType<? extends EntityPenguin> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.PENGUIN_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new PenguinLookController(this, 10);
        this.hasChildTextures = true;
        this.field_70138_W = 1.0f;
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.2, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsPenguin;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_EMPERORPENGUIN_AMBIENT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.prevPenguinPitch = this.penguinPitch;
        this.penguinPitch = this.field_70171_ac ? (float)((double)this.penguinPitch + (double)(-90.0f - this.penguinPitch) * 0.02) : (this.field_70122_E ? 0.0f : Math.max(0.0f, (float)((double)this.penguinPitch - 1.8)));
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (worldIn.func_201674_k().nextInt(7) == 0) {
            this.generateChildren();
        }
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public EntityPenguin createChild(AgeableEntity ageable) {
        EntityPenguin entityPenguin = new EntityPenguin((EntityType<? extends EntityPenguin>)((EntityType)ExoticBirdsEntities.PENGUIN.get()), this.field_70170_p);
        entityPenguin.setVariant(this.getChildVariant());
        return entityPenguin;
    }

    public boolean func_70648_aU() {
        return false;
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.9f;
    }

    public class PenguinLookController
    extends LookController {
        private final EntityPenguin penguin;
        private final int offset;

        public PenguinLookController(EntityPenguin entity, int offsetIn) {
            super((MobEntity)entity);
            this.offset = offsetIn;
            this.penguin = entity;
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                this.field_75655_d = false;
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h() + 20.0f, this.field_75657_b);
            } else {
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, this.field_75657_b);
            }
            float f = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
            if (f < (float)(-this.offset)) {
                this.field_75659_a.field_70761_aq -= 4.0f;
            } else if (f > (float)this.offset) {
                this.field_75659_a.field_70761_aq += 4.0f;
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityPenguin penguin;

        public MoveHelperController(EntityPenguin penguinIn) {
            super((MobEntity)penguinIn);
            this.penguin = penguinIn;
        }

        public void func_75641_c() {
            if (this.penguin.func_208600_a(FluidTags.field_206959_a)) {
                this.penguin.func_213317_d(this.penguin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.penguin.func_70090_H()) {
                if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.penguin.func_70661_as().func_75500_f()) {
                    double d0 = this.field_75646_b - this.penguin.field_70165_t;
                    double d1 = this.field_75647_c - this.penguin.field_70163_u;
                    double d2 = this.field_75644_d - this.penguin.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    d1 /= d3;
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.penguin.field_70761_aq = this.penguin.field_70177_z = this.func_75639_a(this.penguin.field_70177_z, f, 10.0f);
                    this.penguin.field_70759_as = this.penguin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.penguin.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 10.0);
                    this.penguin.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.penguin.func_70689_ay(), (float)f1));
                    if (this.penguin.func_208600_a(FluidTags.field_206959_a)) {
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.penguin.field_70125_A = this.func_75639_a(this.penguin.field_70125_A, f2, 5.0f);
                    }
                } else {
                    this.penguin.func_70659_e(0.0f);
                }
            } else {
                super.func_75641_c();
            }
        }
    }
}

