/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javafx.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;

public class PacketSyncCapabilities {
    private final Set<Pair<EntityType, Integer>> trackedBirdList;

    public PacketSyncCapabilities(Set<Pair<EntityType, Integer>> trackedBirdList) {
        this.trackedBirdList = trackedBirdList;
    }

    public static void encode(PacketSyncCapabilities message, PacketBuffer buffer) {
        buffer.writeInt(message.trackedBirdList.size());
        for (Pair<EntityType, Integer> pair : message.trackedBirdList) {
            buffer.func_192572_a(new ResourceLocation(Registry.field_212629_r.func_177774_c(pair.getKey()).toString()));
            buffer.writeInt(((Integer)pair.getValue()).intValue());
        }
    }

    public static PacketSyncCapabilities decode(PacketBuffer buffer) {
        HashSet<Pair<EntityType, Integer>> trackedBirds = new HashSet<Pair<EntityType, Integer>>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            ResourceLocation resource = buffer.func_192575_l();
            int variant = buffer.readInt();
            Registry.field_212629_r.func_218349_b(resource).ifPresent(type -> trackedBirds.add(new Pair(type, (Object)variant)));
        }
        return new PacketSyncCapabilities(trackedBirds);
    }

    public static void handle(PacketSyncCapabilities packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncCapabilities.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketSyncCapabilities packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> cap.setAll(packet.trackedBirdList));
        }
    }
}

