/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.worldgen;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.pavocado.exoticbirds.block.BlockNest;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.tileentity.TileEntityNest;

public class ScatteredNestFeature
extends Feature<NoFeatureConfig> {
    public ScatteredNestFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private int getTopBlockY(IWorld world, int posX, int posZ) {
        IChunk chunk = world.func_217349_x(new BlockPos(posX, 0, posZ));
        posX &= 0xF;
        posZ &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            BlockState block = chunk.func_180495_p(new BlockPos(posX, k, posZ));
            if (!block.func_185904_a().func_76230_c()) continue;
            return k;
        }
        return -1;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        ResourceLocation currentDimension = DimensionType.func_212678_a((DimensionType)worldIn.func_201675_m().func_186058_p());
        if (currentDimension != null) {
            for (String dimensionType : ExoticBirdsConfig.blacklistedNestGenDimensions) {
                if (!dimensionType.equals(currentDimension.toString())) continue;
                return false;
            }
        }
        int i = 0;
        for (int j = 0; j < ExoticBirdsConfig.nestGenRate; ++j) {
            int Zcoord;
            int Ycoord;
            int Xcoord;
            BlockPos blockpos;
            BlockPos nestpos;
            if (rand.nextInt(8) != 0 || ExoticBirdsConfig.blacklistedNestGenBiomes.contains(worldIn.func_180494_b(nestpos = (blockpos = new BlockPos(Xcoord = pos.func_177958_n() + (rand.nextInt(8) - rand.nextInt(8)), Ycoord = this.getTopBlockY(worldIn, Xcoord, Zcoord = pos.func_177952_p() + (rand.nextInt(8) - rand.nextInt(8))), Zcoord)).func_177984_a()).getRegistryName().toString()) || !worldIn.func_175623_d(nestpos) || !(worldIn.func_180495_p(blockpos).func_177230_c() instanceof LeavesBlock)) continue;
            worldIn.func_180501_a(nestpos, ((BlockNest)ExoticBirdsBlocks.NEST.get()).func_176223_P(), 2);
            ++i;
            TileEntity tileEntity = worldIn.func_175625_s(nestpos);
            if (!(tileEntity instanceof TileEntityNest)) continue;
            int eggCount = 0;
            for (int k = 0; k < 3; ++k) {
                if (rand.nextInt(3) != 0) continue;
                ((TileEntityNest)tileEntity).inventory.setStackInSlot(k, new ItemStack((IItemProvider)ExoticBirdsItems.MYSTERY_EGG.get(), 1));
                ++eggCount;
            }
            worldIn.func_180501_a(nestpos, (BlockState)worldIn.func_180495_p(nestpos).func_206870_a((IProperty)BlockNest.EGGS, (Comparable)Integer.valueOf(eggCount)), 2);
        }
        return i > 0;
    }
}

