/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft;

import com.mojang.serialization.Codec;
import dev.driscollcreations.explorercraft.bamboogrove.items.JadeBowItem;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveItems;
import dev.driscollcreations.explorercraft.setup.ExplorerConfiguredStructures;
import dev.driscollcreations.explorercraft.setup.ExplorerFeature;
import dev.driscollcreations.explorercraft.setup.ExplorerStructures;
import dev.driscollcreations.explorercraft.setup.Registration;
import dev.driscollcreations.explorercraft.util.ExplorerVanillaCompat;
import dev.driscollcreations.explorercraft.util.ExplorercraftResourceLocation;
import dev.driscollcreations.explorercraft.vanillatweaks.client.ClientEvents;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="explorercraft")
public class Explorercraft {
    public static final String MOD_ID = "explorercraft";
    public static final Logger LOGGER = LogManager.getLogger();
    private static Method GETCODEC_METHOD;

    public Explorercraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Registration.register();
        ExplorerStructures.STRUCTURES.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        ExplorerFeature.FEATURES.register(modEventBus);
        ExplorerFeature.FOLIAGE_PLACER_TYPES.register(modEventBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExplorerFeature.Configured.registerConfiguredFeatures();
            ExplorerStructures.setupStructures();
            ExplorerConfiguredStructures.registerConfiguredStructures();
            ExplorerVanillaCompat.register();
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BambooGroveBlocks.BAMBOO_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_BAMBOO_SAPLING.get());
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BambooGroveBlocks.CHERRY_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_CHERRY_SAPLING.get());
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BambooGroveBlocks.MAPLE_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_MAPLE_SAPLING.get());
        });
        EnchantmentType.BOW.func_77557_a((Item)BambooGroveItems.JADE_BOW.get());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        JadeBowItem.initPropertyOverride();
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.CHERRY_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_BAMBOO_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_CHERRY_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_MAPLE_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.BAMBOO_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_DOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.RICE_BASE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BambooGroveBlocks.RICE_TOP.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)VanillaTweaksBlocks.DISSOLVED_STONE.get()), (RenderType)RenderType.func_228645_f_());
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    public static ExplorercraftResourceLocation getId(String path) {
        if (path.contains(":")) {
            throw new IllegalArgumentException("path contains namespace");
        }
        return new ExplorercraftResourceLocation(path);
    }

    public void biomeModification(BiomeLoadingEvent event) {
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(ExplorerStructures.SAKURA_TREE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ExplorerStructures.SAKURA_TREE.get()));
            tempMap.putIfAbsent(ExplorerStructures.TORII_GATE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ExplorerStructures.TORII_GATE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

