/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.bamboogrove.world.feature;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.driscollcreations.explorercraft.setup.ExplorerFeature;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class BambooFoliagePlacer
extends FoliagePlacer {
    public static final Codec<BambooFoliagePlacer> CODEC = RecordCodecBuilder.create(p_236742_0_ -> BambooFoliagePlacer.blobParts(p_236742_0_).apply((Applicative)p_236742_0_, BambooFoliagePlacer::new));
    protected final int height;

    protected static <P extends BambooFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, FeatureSpread, FeatureSpread, Integer> blobParts(RecordCodecBuilder.Instance<P> p_236740_0_) {
        return BambooFoliagePlacer.func_242830_b(p_236740_0_).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(p_236741_0_ -> p_236741_0_.height));
    }

    public BambooFoliagePlacer(FeatureSpread radius, FeatureSpread offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return (FoliagePlacerType)ExplorerFeature.BAMBOO_FOLIAGE_TYPE.get();
    }

    protected void func_230372_a_(IWorldGenerationReader worldGenerationReader, Random random, BaseTreeFeatureConfig treeFeatureConfig, int treeHeight, FoliagePlacer.Foliage foliage, int foilageHeight, int radius, Set<BlockPos> set, int offset, MutableBoundingBox boundingBox) {
        for (int i = offset; i >= offset - foilageHeight; --i) {
            int j = Math.max(radius + foliage.func_236764_b_() - 0, 0);
            this.func_236753_a_(worldGenerationReader, random, treeFeatureConfig, foliage.func_236763_a_(), j, set, i, foliage.func_236765_c_(), boundingBox);
        }
    }

    public int func_230374_a_(Random random, int height, BaseTreeFeatureConfig config) {
        return this.height;
    }

    protected boolean func_230373_a_(Random random, int j, int offset, int k, int radius, boolean isDoubleTrunk) {
        return j == radius && k == radius && (random.nextInt(2) == 0 || offset == 0);
    }

    protected void func_236753_a_(IWorldGenerationReader world, Random random, BaseTreeFeatureConfig config, BlockPos blockPos, int radius, Set<BlockPos> set, int offset, boolean isDoubleTrunk, MutableBoundingBox boundingBox) {
        int i = isDoubleTrunk ? 1 : 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.func_230375_b_(random, j, offset, k, radius, isDoubleTrunk)) continue;
                blockpos$mutable.func_239621_a_((Vector3i)blockPos, j, offset, k);
                if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable)) continue;
                world.func_180501_a((BlockPos)blockpos$mutable, config.field_227369_n_.func_225574_a_(random, (BlockPos)blockpos$mutable), 19);
                config.field_227369_n_.func_225574_a_(random, (BlockPos)blockpos$mutable).func_235734_a_((IWorld)world, (BlockPos)blockpos$mutable, 3);
                boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)blockpos$mutable, (Vector3i)blockpos$mutable));
                set.add(blockpos$mutable.func_185334_h());
            }
        }
    }
}

