/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.bamboogrove.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import dev.driscollcreations.explorercraft.Explorercraft;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Level;

public class BlackstoneDungeonStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 9), (Object)new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 100, 4, 9));
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200791_e, 30, 10, 15), (Object)new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 100, 1, 2));

    public BlackstoneDungeonStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            Random random = new Random();
            int min = 10;
            int max = 40;
            int y = random.nextInt(max - min) + min;
            BlockPos blockpos = new BlockPos(x, y, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("explorercraft", "dungeon_start")), 6), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.func_202500_a();
            Explorercraft.LOGGER.log(Level.DEBUG, "Dungeon spawned at " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

