/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.data.client;

import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ExplorerItemModelProvider
extends ItemModelProvider {
    List<String> treeTypes = Arrays.asList("bamboo", "cherry", "maple");
    List<String> oreTypes = Arrays.asList("jade");

    public ExplorerItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "explorercraft", existingFileHelper);
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        this.withExistingParent("jade_block", this.modLoc("block/jade_block"));
        this.withExistingParent("jade_ore", this.modLoc("block/jade_ore"));
        this.withExistingParent("slimey_stone", this.modLoc("block/slimey_stone"));
        this.withExistingParent("dissolved_stone", this.modLoc("block/dissolved_stone"));
        this.withExistingParent("rice_straw_block", this.modLoc("block/rice_straw_block"));
        this.builderMod((ModelFile)itemGenerated, "item/rice");
        this.builderMod((ModelFile)itemGenerated, "item/rice_straw");
        this.builderMod((ModelFile)itemGenerated, "item/cherry_blossom");
        this.builderMod((ModelFile)itemGenerated, "item/rice_bowl");
        this.builderMod((ModelFile)itemGenerated, "item/onigiri");
        this.builderMod((ModelFile)itemGenerated, "item/salmon_sushi");
        this.builderMod((ModelFile)itemGenerated, "item/tamago_sushi");
        for (String ore : this.oreTypes) {
            this.builderMod((ModelFile)itemGenerated, "item/" + ore);
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_horse_armor");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_axe");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_hoe");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_pickaxe");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_shovel");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_sword");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_helmet");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_chestplate");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_leggings");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_boots");
        }
        this.withExistingParent("cherry_blossom_button", this.modLoc("block/cherry_blossom_button_inventory"));
        this.builderMod((ModelFile)itemGenerated, "item/cherry_blossom_door");
        this.fenceInventory("cherry_blossom_fence", this.modLoc("block/cherry_blossom_planks"));
        this.fenceGate("cherry_blossom_fence_gate", this.modLoc("block/cherry_blossom_planks"));
        this.withExistingParent("cherry_blossom_planks", this.modLoc("block/cherry_blossom_planks"));
        this.withExistingParent("cherry_blossom_pressure_plate", this.modLoc("block/cherry_blossom_pressure_plate"));
        this.withExistingParent("cherry_blossom_slab", this.modLoc("block/cherry_blossom_slab"));
        this.withExistingParent("cherry_blossom_stairs", this.modLoc("block/cherry_blossom_stairs"));
        this.withExistingParent("cherry_blossom_trapdoor", this.modLoc("block/cherry_blossom_trapdoor_bottom"));
        this.builderMod((ModelFile)itemGenerated, "item/cherry_panel");
        this.builderMod((ModelFile)itemGenerated, "item/bamboo_panel");
        for (String tree : this.treeTypes) {
            this.withExistingParent(tree + "_button", this.modLoc("block/" + tree + "_button_inventory"));
            this.builderMod((ModelFile)itemGenerated, "item/" + tree + "_door");
            this.fenceInventory(tree + "_fence", this.modLoc("block/" + tree + "_planks"));
            this.fenceGate(tree + "_fence_gate", this.modLoc("block/" + tree + "_planks"));
            this.withExistingParent(tree + "_leaves", this.modLoc("block/" + tree + "_leaves"));
            this.withExistingParent(tree + "_planks", this.modLoc("block/" + tree + "_planks"));
            if (tree.equals("bamboo")) {
                this.withExistingParent(tree + "_planks_vertical", this.modLoc("block/" + tree + "_planks_vertical"));
                this.bambooInventoryBuilder(tree + "_log", this.modLoc("block/" + tree + "_log"), this.modLoc("block/" + tree + "_log_top"));
            }
            this.withExistingParent(tree + "_pressure_plate", this.modLoc("block/" + tree + "_pressure_plate"));
            this.builderMod((ModelFile)itemGenerated, tree + "_sapling", "block/" + tree + "_sapling");
            this.builderMc((ModelFile)itemGenerated, "potted_" + tree + "_sapling", "item/flower_pot");
            this.withExistingParent(tree + "_slab", this.modLoc("block/" + tree + "_slab"));
            this.withExistingParent(tree + "_stairs", this.modLoc("block/" + tree + "_stairs"));
            this.withExistingParent(tree + "_trapdoor", this.modLoc("block/" + tree + "_trapdoor_bottom"));
            if (tree.equals("bamboo")) continue;
            this.withExistingParent(tree + "_log", this.modLoc("block/" + tree + "_log"));
            this.withExistingParent(tree + "_stripped_log", this.modLoc("block/" + tree + "_stripped_log"));
            this.withExistingParent(tree + "_wood", this.modLoc("block/" + tree + "_wood"));
            this.withExistingParent(tree + "_stripped_wood", this.modLoc("block/" + tree + "_stripped_wood"));
        }
    }

    private ItemModelBuilder builderMod(ModelFile itemGenerated, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.modLoc(name));
    }

    private ItemModelBuilder builderMc(ModelFile itemGenerated, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.mcLoc(name));
    }

    private ItemModelBuilder builderMod(ModelFile itemGenerated, String name, String textureLoc) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.modLoc(textureLoc));
    }

    private ItemModelBuilder builderMc(ModelFile itemGenerated, String name, String textureLoc) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.mcLoc(textureLoc));
    }

    private ItemModelBuilder bambooInventoryBuilder(String name, ResourceLocation side, ResourceLocation end) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "explorercraft:block/bamboo_inventory")).texture("side", side)).texture("end", end);
    }
}

