/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import com.google.common.collect.ImmutableList;
import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.BambooLogBlock;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.BambooFoliagePlacer;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.RicePaddyFeature;
import dev.driscollcreations.explorercraft.setup.ExplorerConfiguredStructures;
import dev.driscollcreations.explorercraft.vanillatweaks.world.feature.SlimeBlockFeature;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.ForkyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="explorercraft")
public class ExplorerFeature {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"explorercraft");
    public static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)"explorercraft");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> BAMBOO_TREE = FEATURES.register("bamboo_tree", () -> new TreeFeature(BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new TreeFeature(BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> RICE_PADDY = FEATURES.register("rice_paddy", () -> new RicePaddyFeature());
    public static final RegistryObject<Feature<NoFeatureConfig>> SLIMEY_CHUNK = FEATURES.register("slimey_chunk", () -> new SlimeBlockFeature());
    public static final RegistryObject<FoliagePlacerType<BambooFoliagePlacer>> BAMBOO_FOLIAGE_TYPE = FOLIAGE_PLACER_TYPES.register("bamboo_foliage_placer", () -> new FoliagePlacerType(BambooFoliagePlacer.CODEC));

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        ResourceLocation biome = event.getName();
        Random rand = new Random();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (biome == Biomes.field_76780_h.getRegistryName() || biome == Biomes.field_150599_m.getRegistryName()) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_SWAMP);
        } else if (rand.nextInt(20) == 0) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_GLOBAL);
        }
        if (biome.toString().contains("bamboo_grove")) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Generating bamboo trees: " + biome);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Configured.BAMBOO_TREE.func_227227_a_(0.9f), (Object)Configured.CHERRY_TREE.func_227227_a_(0.01f), (Object)Configured.MAPLE_TREE.func_227227_a_(0.01f)), Configured.BAMBOO_TREE)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(30, 0.1f, 1))));
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.JADE_ORE);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.RICE_PADDY);
            event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_SAKURA_TREE);
            event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_TORII_GATE);
            generation.func_242516_a(StructureFeatures.field_244135_a);
        }
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> BAMBOO_TREE = ((Feature)BAMBOO_TREE.get()).func_225566_b_((IFeatureConfig)Configs.BAMBOO_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> CHERRY_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)Configs.CHERRY_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> MAPLE_TREE = ((Feature)MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MAPLE_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> JADE_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)Configs.JADE_ORE_CONFIG).func_242733_d(24)).func_242728_a();
        public static final ConfiguredFeature<?, ?> RICE_PADDY = ((Feature)RICE_PADDY.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_SWAMP = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(40)).func_242728_a()).func_242731_b(33);
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_GLOBAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(40)).func_242728_a()).func_242731_b(20);

        public static void registerConfiguredFeatures() {
            Configured.register("bamboo_tree", BAMBOO_TREE);
            Configured.register("cherry_treee", CHERRY_TREE);
            Configured.register("maple_tree", MAPLE_TREE);
            Configured.register("jade_ore", JADE_ORE);
            Configured.register("rice_paddy", RICE_PADDY);
            Configured.register("slimey_chunk_swamp", SLIMEY_CHUNK_SWAMP);
            Configured.register("slimey_chunk_global", SLIMEY_CHUNK_GLOBAL);
        }

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("explorercraft", name), configuredFeature);
        }
    }

    public static final class Configs {
        public static final BaseTreeFeatureConfig BAMBOO_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((BambooLogBlock)BambooGroveBlocks.BAMBOO_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.BAMBOO_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BambooFoliagePlacer(FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)1), 6), (AbstractTrunkPlacer)new StraightTrunkPlacer(12, 10, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig CHERRY_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)BambooGroveBlocks.CHERRY_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.CHERRY_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)BambooGroveBlocks.MAPLE_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.MAPLE_LEAVES.get()).func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new ForkyTrunkPlacer(4, 2, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_();
        public static final OreFeatureConfig JADE_ORE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)BambooGroveBlocks.JADE_ORE.get()).func_176223_P(), 8);
    }
}

