/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import dev.driscollcreations.explorercraft.bamboogrove.world.structures.BlackstoneDungeonStructure;
import dev.driscollcreations.explorercraft.bamboogrove.world.structures.RunDownHouseStructure;
import dev.driscollcreations.explorercraft.bamboogrove.world.structures.SakuraTreeStructure;
import dev.driscollcreations.explorercraft.bamboogrove.world.structures.ToriiGateStructure;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExplorerStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"explorercraft");
    public static final RegistryObject<Structure<NoFeatureConfig>> RUN_DOWN_HOUSE = ExplorerStructures.registerStructure("run_down_house", () -> new RunDownHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> BLACKSTONE_DUNGEON = ExplorerStructures.registerStructure("blackstone_dungeon", () -> new BlackstoneDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SAKURA_TREE = ExplorerStructures.registerStructure("sakura_tree", () -> new SakuraTreeStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> TORII_GATE = ExplorerStructures.registerStructure("torii_gate", () -> new ToriiGateStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        ExplorerStructures.setupMapSpacingAndLand((Structure)RUN_DOWN_HOUSE.get(), new StructureSeparationSettings(10, 5, 1234567890), true);
        ExplorerStructures.setupMapSpacingAndLand((Structure)BLACKSTONE_DUNGEON.get(), new StructureSeparationSettings(30, 15, 564645743), false);
        ExplorerStructures.setupMapSpacingAndLand((Structure)SAKURA_TREE.get(), new StructureSeparationSettings(20, 6, 647785356), true);
        ExplorerStructures.setupMapSpacingAndLand((Structure)TORII_GATE.get(), new StructureSeparationSettings(40, 20, 539272656), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

