/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class ExplorerTrades {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof PlayerEntity && entityBeingMounted instanceof AbstractHorseEntity) {
            PlayerEntity player = (PlayerEntity)mountingEntity;
            AbstractHorseEntity horse = (AbstractHorseEntity)entityBeingMounted;
            if (!horse.func_110248_bS() && player.func_184812_l_()) {
                Explorercraft.LOGGER.error("Horse was tamed instantly");
                horse.func_184779_b(player.func_110124_au());
                horse.func_110234_j(true);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        ExplorerTrades.addWandererTrades(event, new VillagerTrades.ITrade[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()).func_199767_j(), 1, 3, 1)});
        ExplorerTrades.addRareWandererTrades(event, new VillagerTrades.ITrade[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.CHERRY_SAPLING.get()).func_199767_j(), 1, 3, 1), new ExplorerTrade(1, ((Block)BambooGroveBlocks.MAPLE_SAPLING.get()).func_199767_j(), 1, 3, 1), new ExplorerTrade(1, ((Item)BambooGroveItems.CHERRY_BLOSSOM.get()).func_199767_j(), 1, 12, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.field_221156_f, 1, new VillagerTrades.ITrade[]{new ExplorerTrade((Item)BambooGroveItems.RICE.get(), 32, 1, 16, 2)});
    }

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (event.getType() == profession) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, profession, level, trades);
        }
    }

    public static void addCompatWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addWandererTrades(event, trades);
        }
    }

    public static void addCompatRareWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addRareWandererTrades(event, trades);
        }
    }

    public static class ExplorerTrade
    extends BasicTrade {
        public ExplorerTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMult) {
            super(input, input2, output, maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp) {
            this(input, inputCount, output, outputCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

