#version 120

//#define BrightNoon
#define AO

const int shadowMapResolution = 2048; //[1024 1732 2048 3766 4096]
const float ShadowMapBias = 0.85;
const float noiseTextureResolution = 32;
const float sunPathRotation = -25.0;
const float ambientOcclusionLevel = 0.5; //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
const float shadowDistance = 128.0; //[128.0 256.0 512.0 1024.0]
const bool shadowHardwareFiltering = true;
const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float zenithOffset = 0.0;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)
#define wCaustics
#define cDistThreshold 0.15 //[0.05 0.15 0.25 0.35 0.45 0.55 0.65 0.75]

uniform sampler2DShadow shadowtex0;
uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

uniform sampler2D tex;
uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex7;
uniform sampler2D colortex6;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferProjection;

uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 shadowLightPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;

uniform int isEyeInWater; 
uniform int frameCounter;
uniform int worldTime;

varying vec2 texcoord;

varying vec3 lightVector;
varying vec3 viewVector;

float timeVal = sunAngle;

    float tSunrise  = ((clamp(timeVal, 0.96, 1.00)-0.96) / 0.04 + 1-(clamp(timeVal, 0.02, 0.15)-0.02) / 0.13);
    float tNoon     = ((clamp(timeVal, 0.02, 0.15)-0.02) / 0.13   - (clamp(timeVal, 0.35, 0.48)-0.35) / 0.13);
    float tSunset   = ((clamp(timeVal, 0.35, 0.48)-0.35) / 0.13   - (clamp(timeVal, 0.50, 0.53)-0.50) / 0.03);
    float tNight    = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.03);


#include "/lib/pos.glsl"
#include "/lib/poisson.glsl"

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a)  (bayer64(.5*(a))*.25+bayer2(a))

float timeAngle = worldTime/24000.0;
float timeBrightness = max(sin(timeAngle*6.28318530718),0.0);


mat2 getRotationMatrix(in vec2 coord) {
    float rotationAmount = texture2D(
        noisetex,
        coord * vec2(
            viewWidth / noiseTextureResolution,
            viewHeight / noiseTextureResolution
        )
    ).r;
    return mat2(
        cos(rotationAmount), -sin(rotationAmount),
        sin(rotationAmount), cos(rotationAmount)
    );
}


vec3 shadowCoord;
mat2 rotationMatrix = getRotationMatrix(texcoord.st);

float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

void getShadows(in vec3 shadowCoord, in mat2 rotationMatrix, in bool watermask, out float shadow, out vec3 shadowcolor) {
    shadow = 0.0;         //always initialize these, otherwise you can get weirdness galore, especially on nvidia
    vec4 tempcol = vec4(0.0); //this is for storing the shadowcolor before making it use-ready

        for (int i = 0; i < shadowSamples.length(); i++) {
            vec2 Offset = shadowSamples[i] / shadowMapResolution;
            Offset = rotationMatrix * Offset;
            float shadow0sample = shadow2D(shadowtex0, vec3(shadowCoord.xy+Offset, shadowCoord.z)).r;
            float shadow1sample = shadow2D(shadowtex1, vec3(shadowCoord.xy+Offset, shadowCoord.z)).r;
        shadow += shadow1sample;
               bool mask = abs(shadow1sample-shadow0sample)>0.1;         //this is better with a slight threshold
            if (mask) {
                if (isEyeInWater == 0 && texture2D(colortex2, texcoord).x<0.2 && watermask) tempcol += texture2D(shadowcolor0, shadowCoord.xy+Offset);
            } else tempcol += vec4(1.0, 1.0, 1.0, 0.0);
        }
        tempcol /= shadowSamples.length();
        shadow /= shadowSamples.length();

    shadowcolor = mix(vec3(1.0), tempcol.rgb*tempcol.rgb, sqrt(tempcol.a));
}

float lind(float depth) {
   return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec3 getVolumetricRays(float depthtex0, float depthtex1, vec3 color, float dither) {
	vec3 vl = vec3(0.0);
	
	vec4 cameraPos = getCameraSpacePos(texcoord, depthtex0);

    dither    = fract(dither + frameCounter/32.0);
	
	float cosS = dot(normalize(cameraPos.xyz), normalize(sunPosition) * (1.0 - 2.0 * timeAngle));
	float visfactor = 0.02 * (- 0.2 * timeBrightness + 1.0) * (3.0 * rainStrength + 1.0);
	float invvisfactor = 1.0 - visfactor;

    int samplecount = 9;

    float visibility = 1.0 / 9;
    
	if (visibility > 0.0){
		float maxDist = 512.0;
		
		float depthLinear0 = lind(depthtex0);
		float depthLinear1 = lind(depthtex1);
		vec3 worldposition = vec3(0.0);
		
		for (int i = 0; i < samplecount; i++) {
			float minDist = (i + dither) * maxDist / 9 + 0.05;
			if (minDist > maxDist) break;

			if (depthLinear1 < minDist || (depthLinear0 < minDist && color == vec3(0.0))){
				break;
			}


			worldposition = getShadowSpacePos(texcoord, distx(minDist), lightVector , 0.08);

			if (length(worldposition.xy*2.0-1.0)<1.0){
				vec3 sample = vec3(shadow2D(shadowtex0, vec3(worldposition.xy, worldposition.z)).z);
				
				vec3 colsample = vec3(0.0);
				if (sample.r < 0.9){
					float testsample = shadow2D(shadowtex1, vec3(worldposition.xy, worldposition.z)).z;
					if (testsample > 0.9) colsample = texture2D(shadowcolor0, worldposition.xy).rgb;
					sample = max(sample,colsample*colsample);
				}
				if (depthLinear0 < minDist) sample *= color;

				vl += sample;
            }else{
				vl += 1.0;
			}
		}
		vl = sqrt(vl/9);
	}
	
	return vl;
}

float noise2De(in vec2 coord, in float size, in vec2 offset) {
    coord      *= size;
    coord      += offset;
    coord      /= noiseTextureResolution;
    return texture2D(noisetex, coord).r*2.0-1.0;
}

float waterH(vec3 wpos) {
    float windAnim = -frameTimeCounter*0.2;
    
    vec2 tick = vec2(windAnim, 0.0);
    vec3 wind = vec3(tick.x, 0.5*windAnim, tick.y);

    vec3 rpos = wpos;
    rpos.y *= 0.0;

    float noise = noise2De(rpos.xz, 0.2, tick);
        noise += noise2De(rpos.xz, 0.6, tick*1.2)*0.25;
        noise += noise2De(rpos.xz, 1.4, tick*1.5)*0.025;
        noise += noise2De(rpos.xz, 1.6, tick*1.9)*0.0125;
	
    return noise * 0.72;
}
#ifdef wCaustics
float CalcWaterC(vec4 worldPos, float dither) {
    dither    = fract(dither + frameCounter/8.0);
    
	vec3 NWLightvec = -normalize(mat3(gbufferModelViewInverse) * lightVector.xyz);
	float detectwVL = min(abs(worldPos.y - 63.0), 2.0);
	vec3 FRFvec = refract(NWLightvec, vec3(0.0, 1.0, 0.0), 1.0 / 1.3333);
	float detectwL = detectwVL / -FRFvec.y;
	vec3 lookupCenter = worldPos.xyz - FRFvec * detectwL;

	const int s = 1;
	int c = 0;

	float caustics = 0.0;

	for (int i = -s; i <= s; i++)
	{
		for (int j = -s; j <= s; j++)
		{
			vec2 offset = vec2(i + vec2(dither, dither).x, j + vec2(dither, dither).y) * 0.35;
			vec3 detectlookup = lookupCenter + vec3(offset.x, 0.0, offset.y);
			vec3 wNormal = vec3(waterH(detectlookup)).xzy;
			vec3 RFvec = refract(NWLightvec.xyz, wNormal.xyz, 1.0 / 1.3333);
			float rayL = detectwVL / RFvec.y;
			vec3 detectcollision = detectlookup - RFvec * rayL;

			float dist = dot(detectcollision - worldPos.xyz, detectcollision - worldPos.xyz) * 7.1;

			caustics += 1.0 - clamp(dist / cDistThreshold, 0.0, 1.0);

			c++;
		}
	}

	caustics /= c;

	return pow(caustics/cDistThreshold, 2.0) * 3.0;
}
#endif

#define AOStrength 2.0	//[0.5 0.7 1.0 1.2 1.5 1.7 2.0]
#define AODistance 1.30 //[0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 3.00 4.00 5.00 6.00]

vec2 offsetDist(float x, int s){
	float n = fract(x*1.414)*3.1415;
    return vec2(cos(n),sin(n))*x/s;
}

#ifdef AO
float dbao(sampler2D depth, float dither, vec2 coord){
	float ao = 0.0;

	int samples = 6;
	dither = fract(frameTimeCounter * 4.0 + dither);

	float d = texture2D(depth,coord).r;
	float hand = float(d < 0.56);
	d = ld(d);
	
	float sd = 0.0;
	float angle = 0.0;
	float dist = 0.0;
	vec2 scale = AODistance * vec2(1.0/aspectRatio,1.0) * gbufferProjection[1][1] / (2.74747742 * max(far*d,6.0));

	for (int i = 1; i <= samples; i++) {
		vec2 offset = offsetDist(i + dither, samples) * scale;

		sd = ld(texture2D(depth,coord+offset).r);
		float sample = far*(d-sd)*2.0;
		if (hand > 0.5) sample *= 2048.0;
		angle = clamp(0.5-sample,0.0,1.0);
		dist = clamp(0.25*sample-1.0,0.0,1.0);

		sd = ld(texture2D(depth,coord-offset).r);
		sample = far*(d-sd)*25.0;
		if (hand > 0.5) sample *= 2048.0;
		angle += clamp(0.5-sample,0.0,1.0);
		dist += clamp(0.25*sample-1.0,0.0,1.0);
		
		ao += clamp(angle + dist,0.0,1.0);
	}
	ao /= samples;
	
	return pow(ao,AOStrength);
}
#endif

vec3 lightingCalculation(in vec4 albedo, in float depth, in bool waterm) {
        float shadow;
        vec3 shadowcolor;
    getShadows(shadowCoord, rotationMatrix, waterm, shadow, shadowcolor);
        vec3 normalMap = texture2D(colortex1, texcoord).xyz*2.0-1.0;
        float Diffuse = max(dot(normalMap, normalize(shadowLightPosition)), 0.0);
        #ifdef wCaustics
        if (isEyeInWater == 1) shadow *= CalcWaterC(getWorldSpacePos(texcoord, depth), bayer32(gl_FragCoord.xy));
        #endif
        shadow = min(Diffuse, shadow);
        vec3 nightLight = vec3(0.025);
        vec3 nightAmbient = vec3(0.05);
        #ifdef BrightNoon
        vec3 shadowLight = vec3((vec3(0.9, 0.49, 0.1))*tSunrise + vec3(2.8)*tNoon + (vec3(0.9, 0.49, 0.1))*tSunset + nightLight*tNight);
        #else
        vec3 shadowLight = vec3((vec3(0.9, 0.39, 0.1))*tSunrise + vec3(1.6)*tNoon + (vec3(0.9, 0.49, 0.1))*tSunset + nightLight*tNight);
        #endif
        float torchTex = texture2D(colortex2, texcoord).r*texture2D(colortex2, texcoord).r;
        float skyTex = texture2D(colortex2, texcoord).g*texture2D(colortex2, texcoord).g;
        vec3 ambientLight = vec3((vec3(0.5, 0.5, 0.55)*1.0)*tSunrise + (vec3(0.6, 0.6, 0.7)*0.8)*tNoon + (vec3(0.5, 0.5, 0.55)*1.0)*tSunset + nightAmbient*tNight)*pow(skyTex, 4.0);
        if (isEyeInWater == 1) ambientLight *= 4.2;
        if (isEyeInWater == 1) shadowLight *= 4.2;
    	vec3 torchCol = ((pow(torchTex, 3.0) * 2.7) * vec3(0.9,0.45,0.1));
        #ifdef AO
        float ambientocclusion = dbao(depthtex0, bayer64(gl_FragCoord.xy), texcoord);
        #else
        float ambientocclusion = 1.0;
        #endif

        vec3 calcLight = ((ambientLight+torchCol)*ambientocclusion + (shadow*shadowLight))*shadowcolor;

        return albedo.rgb * calcLight;
}


void main() {
    float id = texture2D(colortex3, texcoord).b*255;
    bool iswaterm = abs(id-8.5)<0.6;

    float depth = texture2D(depthtex0, texcoord).x;
    float belowdepth = texture2D(depthtex1, texcoord).x;

	vec3 nightFogColor = vec3(0.1, 0.5, 1.0)*0.5;
    vec3 noonFogColor = vec3(0.5, 0.5, 0.5)*1.6;
	vec3 sunsetFogColor = vec3(0.7, 0.7, 1.0)*0.5;
    vec3 normalrgb = texture2D(colortex1, texcoord).rgb*2.0-1.0;
	vec3 customFogColor = (sunsetFogColor*tSunrise + noonFogColor*tNoon + sunsetFogColor*tSunset + nightFogColor*tNight);
	vec4 albedo = texture2D(tex, texcoord);
    shadowCoord = getShadowSpacePos(texcoord, depth, lightVector, 0.08);
    if(depth<1.0) albedo.rgb = lightingCalculation(albedo, depth, iswaterm);

    vec3 coeff = ((vec3(0.8,1.0,0.4)*0.1)*tSunrise + (vec3(0.8,1.0,0.4)*0.1)*tNoon + (vec3(0.8,1.0,0.4)*0.1)*tSunrise + (vec3(0.8,1.0,0.4)*0.001)*tNight);
    
    vec4 tex0world = getWorldSpacePos(texcoord, depth);
    tex0world.xyz -= cameraPosition;
    vec4 tex1world = getWorldSpacePos(texcoord, belowdepth);
    tex1world.xyz -= cameraPosition;
    
    float dist = distance(tex0world, tex1world);
    if(iswaterm) albedo.rgb = albedo.rgb * exp(-coeff * dist);
    
/*DRAWBUFFERS:06*/
	gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(getVolumetricRays(depth, texture2D(depthtex1, texcoord).x, albedo.rgb, bayer64(gl_FragCoord.xy)), 1.0);
}