#version 120

#define TAA
//#define RReflections

const int maxf              = 4;				//number of refinements
const float stp             = 1.4;			//size of one step for raytracing algorithm
const float ref             = 0.1;			//refinement multiplier
const float inc             = 1.4;			//increasement factor at each step

const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float zenithOffset = 0.0;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0
vec3 _betaR = vec3(1.95e-2, 1.1e-1, 2.94e-1); 
vec3 _betaM = vec3(4e-2, 4e-2, 4e-2);
#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)

#define FOGMULTIPLIER 0.8 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]

/*
const int colortex3Format = RGBA16;
*/

uniform sampler2D tex;
uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex7;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferProjection;

uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 shadowLightPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;

uniform int isEyeInWater; 
uniform int frameCounter;
uniform int worldTime;

varying vec2 texcoord;

varying vec3 lightVector;
varying vec3 viewVector;

float timeVal = sunAngle;

    float tSunrise  = ((clamp(timeVal, 0.96, 1.00)-0.96) / 0.04 + 1-(clamp(timeVal, 0.02, 0.15)-0.02) / 0.13);
    float tNoon     = ((clamp(timeVal, 0.02, 0.15)-0.02) / 0.13   - (clamp(timeVal, 0.35, 0.48)-0.35) / 0.13);
    float tSunset   = ((clamp(timeVal, 0.35, 0.48)-0.35) / 0.13   - (clamp(timeVal, 0.50, 0.53)-0.50) / 0.03);
    float tNight    = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.03);


float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))

vec4 getCameraSpacePos(in vec2 coord, in float depth) {
    float gdepth = depth;
    vec4 CameraSpacePos = gbufferProjectionInverse*vec4(coord.s * 2.0 - 1.0, coord.t * 2.0 - 1.0, 2.0 * gdepth - 1.0, 1.0);

    return CameraSpacePos / CameraSpacePos.w;
}


vec4 getWorldSpacePos(in vec2 coord, in float depth) {
    vec4 WorldSpacePos = gbufferModelViewInverse*getCameraSpacePos(coord, depth);
    WorldSpacePos.xyz += cameraPosition;

    return WorldSpacePos;
}


float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

float lind(float depth) {
   return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec4 raytrace(vec3 fragpos, vec3 normal, float dither) {
    vec4 color = vec4(0.0);
	dither = fract(dither + frameTimeCounter);

    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(fragpos, normal));
    vec3 vector = exp(stp) * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	float border = 0.0;
	vec3 pos = vec3(0.0);
    pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
	float depth = texture2D(depthtex0,pos.xy).r;
	vec3 spos = vec3(pos.st, depth);
    spos = nvec3(gbufferProjectionInverse * nvec4(spos*2.0-1.0));
    for(int i=0;i<10;i++){
        if (isEyeInWater > 0) break;
		if (pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1) break;
		if (abs(length(fragpos.xyz-spos.xyz)) < pow(length(vector)*pow(length(tvector),0.17),1.1)*1.1){

                sr++;
                if (sr >= maxf) break;
				tvector -=vector;
                vector *=ref;
		}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector * (dither * 0.005 + 0.975);
		fragpos = start + tvector;
    }
	
	if (pos.z <1.0-1e-5){
		border = clamp(1.0 - pow(cdist(pos.st), 200.0), 0.0, 1.0);
		color.a = float(texture2D(depthtex0,pos.xy).r < 1.0);
		if (color.a > 0.5) color.rgb = texture2D(colortex0, pos.st).rgb;
		color.rgb = clamp(color.rgb,vec3(0.0),vec3(8.0));
		color.a *= border;

	}
	
    return color;
}


#ifdef RReflections
vec4 raytraceRough(vec3 fragpos, vec3 normal, float dither, float r){
	vec2 noisecoord = gl_FragCoord.xy/64.0;
    #ifdef TAA
	noisecoord += fract(frameCounter*vec2(0.4,0.25));
    #endif
	r *= r;

	vec4 color = vec4(0.0);
	int steps = 1 + int(4 * r);

		vec3 tangent = normalize(cross(gbufferModelView[1].xyz, normal));
		mat3 tbnMatrix = mat3(tangent, cross(normal, tangent), normal);

	for(int i = 0; i < steps; i++){
		vec3 noise = vec3(texture2D(noisetex,noisecoord+0.1*i).xy*2.0-1.0,0.0);
		noise.xy *= 0.7*r*(i+1.0)/steps;
		noise.z = 1.0 - (noise.x * noise.x + noise.y * noise.y);

		vec3 rnormal = normalize(tbnMatrix * noise);
		
		color += raytrace(fragpos,rnormal,dither);
	}
	color /= steps;
	
	return color;
}
#endif

vec3 getSkyAbsorption(vec3 x, float y){
	
	vec3 absorption = x * -y;
	     absorption = exp2(absorption) * 2.0;
	
	return absorption;
}

float getSunPoint(vec3 p, vec3 lp){
	return smoothstep(0.03, 0.026, distance(p, lp)) * 50.0;
}

float getRayleigMultiplier(vec3 p, vec3 lp){
	return 1.0 + pow(1.0 - clamp(distance(p, lp), 0.0, 1.0), 2.0) * pi * 0.5;
}

float getMie(vec3 p, vec3 lp){
	float disk = clamp(1.0 - pow(distance(p, lp), 0.1), 0.0, 1.0);
	
	return disk*disk*(3.0 - 2.0 * disk) * 2.0 * pi;
}

vec3 getAtmosphericScattering(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase - zenithOffset, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 sun = getSunPoint(p, lp) * absorption;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / (sky + 0.5), sunPointDistMult);
         totalSky += sun + mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

#define getAngle(x) (0.07 / (x * x + 0.07))

vec4 applyReflections(vec4 albedo, vec3 normalmap, vec3 fragpos, float dither, float depth) {
    float fresnelvalue = (150.*tSunrise + 120.*tNoon + 150.*tSunset + 60.*tNight);
    float fresnel = pow(clamp(1.0 + dot(normalmap, fragpos.xyz),0.0,1.0),fresnelvalue);
    vec4 reflections = vec4(0.0);
    vec3 rvec = normalize(reflect(fragpos, normalmap));
    reflections = raytrace(fragpos, normalmap, dither);
    vec3 sky = getAtmosphericScattering(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(sunPosition))*0.1;
    sky += getAtmosphericScattering(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(moonPosition))*(vec3(0.1, 0.2, 0.4)*0.1);
    float mixfog = getAngle(pow(dot(normalize(upPosition), rvec), 1.0));
    sky.rgb += ((vec3(0.8, 0.46, 0.1)*0.4)*tSunrise + (vec3(0.3, 0.7, 1.6)*0.1)*tNoon + (vec3(0.8, 0.46, 0.1)*0.4)*tSunset + vec3(0.0)*tNight);
    albedo.rgb = mix(albedo.rgb, sky.rgb, mixfog);

    albedo.rgb = mix(albedo.rgb,reflections.rgb,fresnel*reflections.a);
    return albedo;
}

#ifdef RReflections
vec4 applyRoughReflections(vec4 albedo, vec3 normalmap, vec3 fragpos, float dither, float roughness) {
    float fresnel = pow(clamp(1.0 + dot(normalmap, normalize(fragpos.xyz)),0.0,1.0),5.5);
    vec4 reflectionsrough = vec4(0.0);

        reflectionsrough = raytraceRough(fragpos, normalmap, dither, roughness);
        albedo.rgb = mix(albedo.rgb,reflectionsrough.rgb,fresnel * reflectionsrough.a);
		albedo.a = mix(albedo.a,1.0,fresnel);
    return albedo;
}
#endif

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

vec3 getNDCSpacePos(vec3 pos){
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = pos * 2. - 1.;
    vec4 fragpos = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragpos.xyz / fragpos.w;
}



void main() {
    float id = texture2D(colortex3, texcoord).b*65535;
    bool iswaterm = id == 8 || id == 9;

    vec2 coord = texcoord;

    float depth = texture2D(depthtex0, texcoord).x;

	vec3 nightFogColor = vec3(0.1, 0.3, 1.0)*0.063;
    vec3 noonFogColor = vec3(0.39, 0.57, 1.0)*1.4;
	vec3 sunsetFogColor = vec3(0.64, 0.36, 0.1)*0.1;

    vec3 normalrgb = texture2D(colortex1, coord).rgb*2.0-1.0;
    vec3 fragpos = getNDCSpacePos(vec3(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z));
	vec3 customFogColor = (sunsetFogColor*tSunrise + noonFogColor*tNoon + sunsetFogColor*tSunset + nightFogColor*tNight);
    customFogColor += vec3(0.5,0.5,0.5)*rainStrength;
	vec4 albedo = texture2D(tex, coord);
    vec4 speculartext = texture2D(colortex4, texcoord.st);
    speculartext.r = pow(1.0 - speculartext.r, 0.7);
    speculartext.g *= speculartext.g;

    if(iswaterm) albedo = applyReflections(albedo, normalrgb, fragpos, bayer16(gl_FragCoord.xy), depth);
    #ifdef RReflections
    if (depth<1.0 && !iswaterm) albedo = applyRoughReflections(albedo, normalrgb, fragpos, bayer16(gl_FragCoord.xy), speculartext.r);
    #endif
    if (depth<1.0 && isEyeInWater == 0) albedo.rgb = mix(albedo.rgb, customFogColor, min(lind(depth) * FOGMULTIPLIER / far, 1.0));
    if(isEyeInWater == 1) albedo.rgb = mix(albedo.rgb, vec3(0.3, 0.6, 2.0)*0.5, min(lind(depth) * 4.2 / far, 1.0));

    
/*DRAWBUFFERS:0*/
	gl_FragData[0] = albedo;
}