#version 120
#extension GL_ARB_shader_texture_lod : enable

#define LightShaft
#define LightShaftStrength 1.50	//[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 3.00 4.00 5.00]
const bool colortex6MipmapEnabled = true;

varying vec3 upVec;
varying vec3 sunVec;

varying vec2 texcoord;

uniform int isEyeInWater;
uniform int worldTime;

uniform float blindness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float sunAngle;

uniform ivec2 eyeBrightnessSmooth;

uniform sampler2D colortex0;
uniform sampler2D colortex6;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

struct SceneData{
    float shadows;
    vec4 albedo;
    float depth;
    vec3 normal;
    vec3 lightvec;
    float diffuse;
} sdata;

float timeVal = sunAngle;

    float tSunrise  = ((clamp(timeVal, 0.96, 1.00)-0.96) / 0.04 + 1-(clamp(timeVal, 0.02, 0.15)-0.02) / 0.13);
    float tNoon     = ((clamp(timeVal, 0.02, 0.15)-0.02) / 0.13   - (clamp(timeVal, 0.35, 0.48)-0.35) / 0.13);
    float tSunset   = ((clamp(timeVal, 0.35, 0.48)-0.35) / 0.13   - (clamp(timeVal, 0.50, 0.53)-0.50) / 0.03);
    float tNight    = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.03);


float eBS = eyeBrightnessSmooth.y/240.0;
float shadowFade = clamp(1.0 - (abs(abs(sunAngle - 0.5) - 0.25) - 0.23) * 100.0, 0.0, 1.0);

void main(){
	sdata.albedo = texture2D(colortex0,texcoord.st);
    sdata.depth = texture2D(depthtex1, texcoord.st).r;
	
	#ifdef LightShaft
	vec3 vl = texture2DLod(colortex6,texcoord.st, 1.5).rgb;
	
	float b = clamp(blindness*2.0-1.0,0.0,1.0);
	b = b*b;

	vec3 lightShaftColor = ((vec3(0.9,0.45,0.1)*1.8)*tSunrise + vec3(0.5, 0.7, 1.0)*tNoon + (vec3(0.9,0.45,0.1)*1.8)*tSunset + (vec3(0.5, 0.7, 1.0)*0.1)*tNight);

	sdata.albedo.rgb += vl * vl * lightShaftColor * LightShaftStrength * (0.5 * (1.0-rainStrength*eBS*0.875) * shadowFade * (1.0-b));
	#endif
/*DRAWBUFFERS:0*/
	gl_FragData[0] = vec4(sdata.albedo);
    gl_FragData[1] = vec4(sdata.depth);
}
