#version 120

#define AnamorphicBloom
#define bloomThreshold 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

const float noiseTextureResolution = 32;
/*
const int colortex0Format = RGBA16F;
const int colortex1Format = RGBA16F;
*/

uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferProjection;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D colortex4;
uniform sampler2D tex;

varying vec2 texcoord;

#include "/lib/pos.glsl"

#define MotionBlur

#define MBlurStrength 1.0 //[0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5]

vec4 getPreviousSpacePos(in vec2 coord, in float depth) {
	vec4 previousPosition = getWorldSpacePos(coord, depth);
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousProjection * gbufferPreviousModelView * previousPosition;
    
    return previousPosition / previousPosition.w;
}

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) (bayer64(.5*(a))*.25+bayer2(a))
#define bayer256(a) (bayer128(.5*(a))*.25+bayer2(a))

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float pi = 3.1415927;

vec3 getMBlur(in vec3 albedo, in float depth, in float hand) {
	float MBg;
    vec3 MBlur = vec3(0.0);
    MBg = 0.0;
    vec2 pixel = 1.5/vec2(viewWidth, viewHeight);
    
    if (hand < 0.5) {
    vec4 Currentpos = vec4(texcoord.s * 2.0 - 1.0, texcoord.t * 2.0 - 1.0, 2.0 * depth - 1.0, 1.0);
    vec2 previousPos = getPreviousSpacePos(texcoord.st, depth).xy;
		vec2 velocity = Currentpos.xy - previousPos;
		velocity = velocity/(1.5+length(velocity))*MBlurStrength*0.02;
        vec2 tcoord2 = vec2(0.0);
		
		vec2 tcoord = texcoord-velocity*(bayer32(gl_FragCoord.xy));
		for (int i = 0; i < 5; ++i){
            tcoord += velocity;
			tcoord2 = clamp(tcoord,pixel,1.0-pixel);
			MBlur += texture2D(colortex0, tcoord2.st).rgb;
			MBg += 1.0;
		}
		MBlur /= MBg;
    } else {
                                  MBlur = albedo;
	}

		return MBlur;
}

vec3 bloomTile(vec4 bloom, float lod, vec2 offset){
	vec4 temp = vec4(0.0);
	float scale = pow(2.0,lod);
	vec2 tcoord = (texcoord.st-offset)*scale;
	float padding = 0.005*scale;

	if (tcoord.s > -padding && tcoord.t > -padding && tcoord.s < 1.0+padding && tcoord.t < 1.0+padding){
		for (int i = 0; i < 10; i++) {
			for (int j = 0; j < 10; j++) {
			float wg = clamp(1.0-length(vec2(i-2,j-2))*0.28,0.0,1.0);
			wg = wg*wg*5.0;
			vec2 tcoord2 = (texcoord.st-offset+vec2(i-2,j-2)*pw*vec2(1.0,aspectRatio))*scale;
			if (wg > 0){
				temp.rgb = ((texture2D(colortex0, tcoord2).rgb)-(bloomThreshold*(1.0/lod)))*wg;
				bloom.rgb += max(temp.rgb*wg, 0.0);
				}
			}
		}
		bloom /= 49;
	}

	return pow(bloom.rgb/128.0,vec3(0.25));
}



void main() {
    vec4 albedo = texture2D(tex, texcoord);
    float depth = texture2D(depthtex1, texcoord).x;

	vec3 blur = vec3(0.0);
    vec4 bloom = vec4(0.0);
	blur += bloomTile(bloom, 2,vec2(0.0,0.0));
	blur += bloomTile(bloom, 3,vec2(0.0,0.26));
	blur += bloomTile(bloom, 4,vec2(0.135,0.26));
	blur += bloomTile(bloom, 5,vec2(0.2075,0.26));
	blur += bloomTile(bloom, 6,vec2(0.235,0.3325));
	blur += bloomTile(bloom, 7,vec2(0.260625,0.3325));
	blur += bloomTile(bloom, 8,vec2(0.3784375,0.3325));
    #ifdef MotionBlur
    float hand = float(texture2D(depthtex1,texcoord).x < 0.56);
    albedo.rgb = getMBlur(albedo.rgb, depth, hand);
    #endif

/*DRAWBUFFERS:01*/
    gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(blur, 1.0);
}