#version 120

//CODE IS TAKEN FROM BSL MADE BY CAPT TATSU

#define Bloom
#define DOF
#define bloomStrength 0.01 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.15 0.2 0.25 0.3 0.4 0.5]
#define DOFStrength 8.0 //[1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0]
#define unblurryDOF

uniform sampler2D depthtex2;
uniform sampler2D depthtex1;
uniform sampler2D colortex0;
uniform sampler2D tex;
uniform sampler2D colortex1;

uniform float viewWidth;
uniform float viewHeight;
uniform float centerDepthSmooth;
uniform float aspectRatio;

varying vec2 texcoord;

vec3 lengthBloom(vec3 x){
	return x*x*128.0;
}

vec3 getBloom(vec3 color, vec2 coord){
	vec3 blur1 = lengthBloom(texture2D(colortex1,coord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb);
	vec3 blur2 = lengthBloom(texture2D(colortex1,coord/pow(2.0,3.0) + vec2(0.0,0.26)).rgb);
	vec3 blur3 = lengthBloom(texture2D(colortex1,coord/pow(2.0,4.0) + vec2(0.135,0.26)).rgb);
	vec3 blur4 = lengthBloom(texture2D(colortex1,coord/pow(2.0,5.0) + vec2(0.2075,0.26)).rgb);
	vec3 blur5 = lengthBloom(texture2D(colortex1,coord/pow(2.0,6.0) + vec2(0.235,0.3325)).rgb);
	vec3 blur6 = lengthBloom(texture2D(colortex1,coord/pow(2.0,7.0) + vec2(0.360625,0.3325)).rgb);
	vec3 blur7 = lengthBloom(texture2D(colortex1,coord/pow(2.0,8.0) + vec2(0.3784375,0.3325)).rgb);

	vec3 blur = (blur1 + blur2 + blur3 + blur4 + blur5 + blur6 + blur7) * 0.06;
	
	return blur*bloomStrength;
}

vec2 DOFfset[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2267, 0.1250 ),
									vec2( -0.2267, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2267, -0.1250 ),
									vec2( 0.2267, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.51295, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.51295, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.51295, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.51295, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));

vec3 depthOfField(vec3 albedo){
	vec3 DOField = vec3(0.0);
	
	float depth = texture2D(depthtex2, texcoord).x;
	float hand = float(depth < 0.46);
    #ifndef unblurryDOF
	float coc = max(abs(depth-centerDepthSmooth)*DOFStrength-0.0001,0.0);
	coc = coc/sqrt(0.001+coc*coc);
	#else
	float coc = max(abs(depth-centerDepthSmooth)*DOFStrength-0.0001,0.0);
	coc = coc/sqrt(0.1+coc*coc);
	#endif

	if (coc*0.015 > 1.0/max(viewWidth,viewHeight) && hand < 0.5){
		for (int i = 0; i < 15; ++i) {
			DOField += texture2D(colortex0, texcoord + DOFfset[i]*coc*0.015*vec2(1.0/aspectRatio,1.0),log2(viewHeight/180.0*aspectRatio/1.7777778)*coc).rgb;
		}
		DOField /= 15.0;
	}
	else DOField = albedo;
	return DOField;
}

void main() {

    vec4 albedo = texture2D(tex,texcoord);

	#ifdef DOF
	albedo.rgb = depthOfField(albedo.rgb);
	#endif

    #ifdef Bloom
    albedo.rgb += getBloom(albedo.rgb, texcoord);
    #endif

/*DRAWBUFFERS:0*/
    gl_FragData[0] = albedo;
}