#version 120

uniform sampler2D tex;

varying vec2 texcoord;

vec3 acesFilm(const vec3 x) {
    const float a = 2.51;
    const float b = 0.003;
    const float c = 2.43;
    const float d = 0.59;
    const float e = 0.54;
    return clamp((x * (a * x + b)) / (x * (c * x + d ) + e), 0.0, 1.0);
}

void main() {
	vec4 albedo = texture2D(tex, texcoord);
	albedo.rgb = acesFilm(albedo.rgb);
	//albedo.rgb /= sqrt(albedo.rgb * albedo.rgb + 1.0);
	
	albedo.rgb = pow(albedo.rgb, vec3(1.0 / 2.2));

/* DRAWBUFFERS:0 */
	gl_FragData[0] = albedo; //gcolor
}