#version 120

//TAA code was used from BSL and Chocapic.

#define TAA

/*
const int RGBA16                 = 1;             
const int colortex5Format        =  RGBA16;
const int colortex6Format        =  RGBA16;
const bool colortex5Clear = false;
const bool colortex6Clear = false;
*/

uniform float viewHeight;
uniform float viewWidth;
uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform sampler2D colortex5;
uniform sampler2D depthtex1;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;

varying vec4 texcoord;

//Previous frame reprojection from Chocapic13
vec2 reprojection(vec3 pos){
		vec4 fragpositionPrev = gbufferProjectionInverse * vec4(pos*2.0-1.0,1.0);
		fragpositionPrev /= fragpositionPrev.w;
		
		fragpositionPrev = gbufferModelViewInverse * fragpositionPrev;

		vec4 previousPosition = fragpositionPrev + vec4(cameraPosition-previousCameraPosition,0.0)*float(pos.z > 0.56);
		previousPosition = gbufferPreviousModelView * previousPosition;
		previousPosition = gbufferPreviousProjection * previousPosition;
		return previousPosition.xy/previousPosition.w*0.5+0.5;
}

vec3 neighbourhoodClamping(vec3 color, vec3 tempcolor, vec2 view){
	vec3 coltl = texture2D(colortex0,texcoord.st+vec2(-1.0,-1.0)*view,1.0).rgb;
	vec3 coltm = texture2D(colortex0,texcoord.st+vec2( 0.0,-1.0)*view,1.0).rgb;
	vec3 coltr = texture2D(colortex0,texcoord.st+vec2( 1.0,-1.0)*view,1.0).rgb;
	vec3 colml = texture2D(colortex0,texcoord.st+vec2(-1.0, 0.0)*view,1.0).rgb;
	vec3 colmr = texture2D(colortex0,texcoord.st+vec2( 1.0, 0.0)*view,1.0).rgb;
	vec3 colbl = texture2D(colortex0,texcoord.st+vec2(-1.0, 1.0)*view,1.0).rgb;
	vec3 colbm = texture2D(colortex0,texcoord.st+vec2( 0.0, 1.0)*view,1.0).rgb;
	vec3 colbr = texture2D(colortex0,texcoord.st+vec2( 1.0, 1.0)*view,1.0).rgb;
	
	vec3 minclr = min(color,min(min(min(coltl,coltm),min(coltr,colml)),min(min(colmr,colbl),min(colbm,colbr))));
	vec3 maxclr = max(color,max(max(max(coltl,coltm),max(coltr,colml)),max(max(colmr,colbl),max(colbm,colbr))));
	
	return clamp(tempcolor,minclr,maxclr);
}

float getDepth = 0.0;

float getblendfactor(vec2 velo) {
    return exp(-length(velo)) * 0.3 + 0.6;
}
void main() {

    getDepth = texture2D(depthtex0, texcoord.st).r;

    vec3 color = texture2D(colortex0,texcoord.st).rgb;

	#ifdef TAA
	vec2 prvcoord = reprojection(vec3(texcoord.st,texture2D(depthtex1,texcoord.st).r));
	vec2 view = vec2(viewWidth,viewHeight);
	vec3 tempcolor = neighbourhoodClamping(color,texture2D(colortex5,texcoord.st).rgb,1.0/view);
	
	vec2 velocity = (texcoord.st-prvcoord.xy)*view;
	float blendfactor = float(prvcoord.x > 0.0 && prvcoord.x < 1.0 && prvcoord.y > 0.0 && prvcoord.y < 1.0);
	blendfactor *= getblendfactor(velocity);
	tempcolor = mix(color,tempcolor,blendfactor);
	#endif

    bool isTerrain = getDepth < 1.0;
/*DRAWBUFFERS:05*/
    #ifdef TAA
        gl_FragData[0] = vec4(tempcolor, 1.0);
        gl_FragData[1] = vec4(tempcolor, 1.0);
    #else
/*DRAWBUFFERS:0*/
    gl_FragData[0] = vec4(color, 1.0);
    #endif
}