#version 120

/*
const int colortex0Format   = RGBA16F;
*/

#define SunsetProfile 1 //[1 2 3]
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 viewVector;

varying vec2 texcoord;

uniform vec2 aspectRatio;

uniform vec3 upPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;

uniform sampler2D colortex0;
uniform sampler2D depthtex1;

float timeVal = sunAngle;

    float tSunrise  = ((clamp(timeVal, 0.96, 1.00)-0.96) / 0.04 + 1-(clamp(timeVal, 0.02, 0.15)-0.02) / 0.13);
    float tNoon     = ((clamp(timeVal, 0.02, 0.15)-0.02) / 0.13   - (clamp(timeVal, 0.35, 0.48)-0.35) / 0.13);
    float tSunset   = ((clamp(timeVal, 0.35, 0.48)-0.35) / 0.13   - (clamp(timeVal, 0.50, 0.53)-0.50) / 0.03);
    float tNight    = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.03);

const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float multiScatterPhase = 0.1;
const float density = 0.7; 

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x, 0.35e-2), 0.75)

vec3 getSkyAbsorption(vec3 x, float y){
	return exp2(x * -y);
}

float getSunPoint(vec3 p, vec3 lp){
	return smoothstep(0.03, 0.026, distance(p, lp)) * 50.0;
}

float getRayleigMultiplier(vec3 p, vec3 lp){
	return 1.0 + pow(1.0 - clamp(distance(p, lp), 0.0, 1.0), 2.0) * pi * 0.5;
}

float getMie(vec3 p, vec3 lp){
	float disk = clamp(1.0 - pow(distance(p, lp), 0.1), 0.0, 1.0);
	
	return disk*disk*(3.0 - 2.0 * disk) * 2.0 * pi;
}

vec3 getAtmosphericScattering(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 sun = getSunPoint(p, lp) * absorption;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += sun + mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

vec3 getAtmosphericScatteringmoon(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

void main() {
	vec3 sunsetcol = vec3(0.8, 0.46, 0.1)*0.4;
	#if SunsetProfile == 1
	sunsetcol = vec3(0.8, 0.46, 0.1)*0.4;
	#endif

	#if SunsetProfile == 2
	sunsetcol = vec3(0.9, 0.16, 0.3)*0.4;
	#endif

	#if SunsetProfile == 3
	sunsetcol = vec3(0.39, 0.57, 1.0)*0.1;
	#endif

    float depth = texture2D(depthtex1, texcoord).x;
	vec3 viewVec = (gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0)).xyz;
    float mixfog = pow(dot(normalize(upPosition), normalize(viewVec)), 1.0);
	vec3 sun =  vec3(smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(sunVec)), 0.0)))*70.0;
    sun = (vec3(0.8, 0.46, 0.1)*tSunrise + vec3(1.0)*tNoon + vec3(0.8, 0.46, 0.1)*tSunset + vec3(0.2, 0.2, 0.5)*tNight)*sun;
    float moon =  smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(moonVec)), 0.0));
    vec4 albedo = texture2D(colortex0, texcoord);
	vec3 atmopsherecols = (sunsetcol*tSunrise + (vec3(0.39, 0.57, 1.0)*0.1)*tNoon + sunsetcol*tSunset + vec3(0.0)*tNight);

    if(depth >= 1.0) { 
		albedo.rgb += getAtmosphericScattering(mat3(gbufferModelViewInverse)*normalize(viewVec.xyz), mat3(gbufferModelViewInverse)*normalize(sunVec))+atmopsherecols;
        albedo.rgb += getAtmosphericScatteringmoon(mat3(gbufferModelViewInverse)*normalize(viewVec.xyz), (mat3(gbufferModelViewInverse)*normalize(moonVec)))*vec3(0.1, 0.2, 0.4);
	}
	albedo.rgb = pow(albedo.rgb, vec3(2.2));

/*DRAWBUFFERS:0*/
    gl_FragData[0] = albedo;
}