#version 120

varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 viewVector;

varying vec2 texcoord;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

void main() {
    gl_Position = ftransform();
    viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    sunVec = normalize(sunPosition);
    moonVec = normalize(moonPosition);
}