#version 120

#define ExposaUnique

#define VClouds


uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex7;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D colortex5;
uniform sampler2D colortex6;

varying vec4 texcoord;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform float frameTimeCounter;
uniform int frameCounter;
uniform float viewHeight;
uniform float viewWidth;
uniform float far;
uniform float near;

uniform vec3 sunPosition;

uniform float rainStrength;
uniform float sunAngle;

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

float getblendfactor(vec2 velo) {
    return exp(-length(velo)) * 0.3 + 0.6;
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))

#define rcp(x) (1.0 / x)

vec2 reprojection(vec3 pos){
		vec4 fragpositionPrev = gbufferProjectionInverse * vec4(pos*2.0-1.0,1.0);
		fragpositionPrev /= fragpositionPrev.w;
		
		fragpositionPrev = gbufferModelViewInverse * fragpositionPrev;

		vec4 previousPosition = fragpositionPrev + vec4(cameraPosition-previousCameraPosition,0.0)*float(pos.z > 0.56);
		previousPosition = gbufferPreviousModelView * previousPosition;
		previousPosition = gbufferPreviousProjection * previousPosition;
		return previousPosition.xy/previousPosition.w*0.5+0.5;
}

void main() {

    const float cLOD    = sqrt(4.0);
    vec2 prvcoord = reprojection(vec3(texcoord.st,texture2D(depthtex1,texcoord.st).x));
	vec2 view = vec2(viewWidth,viewHeight);
    vec3 tempcol = texture2D(colortex6, texcoord.st).rgb;
	vec2 velocity = (texcoord.st-prvcoord.xy)*view;
	float blendfactor = float(prvcoord.x > 0.0 && prvcoord.x < 1.0 && prvcoord.y > 0.0 && prvcoord.y < 1.0);
	blendfactor *= getblendfactor(velocity);
    #ifdef VClouds
    vec2 cloudcoord = texcoord.st*rcp(cLOD);
    vec4 clouds = texture2D(colortex7, cloudcoord);
	clouds.rgb /= 1.0 - clouds.rgb * 0.999;
	tempcol = mix(clouds.rgb,tempcol,blendfactor);
    #endif
    vec4 col = texture2D(colortex0, texcoord.st);
    float depth = texture2D(depthtex0, texcoord.st).x;
    #ifdef VClouds
    if (depth>=1.0) col.rgb = mix(col.rgb, clouds.rgb, clouds.a);
    if (depth>=1.0) col.a = mix(col.a, 1.0, 1.0);
    #endif

/*DRAWBUFFERS:06*/
    gl_FragData[0] = col;
    gl_FragData[1] = vec4(tempcol, 1.0);
   
}