#version 120

#define Vignette
#define FilmGrain
#define Saturation 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Contrast 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
uniform sampler2D tex;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;

varying vec2 texcoord;
varying vec4 color;

varying vec3 viewVector;
varying vec3 moonVec;

vec3 SoftVignette(inout vec3 albedo) {
    float dist = distance(texcoord, vec2(0.5)) * 2.0;

    dist = pow(dist/2.0, 1.1);

    return albedo * (1.0 - dist * (1.0 - dot(albedo, vec3(0.299, 0.587, 0.114))));
}

vec3 getSaturate(vec3 albedo){
    float mixrgb = (albedo.r + albedo.g + albedo.b) / 3.5;
    float weight = Saturation + (1.0 - pow(1.0 - 1.0 * mixrgb, 2.0)) * 0.08;

    return mix(vec3(mixrgb), albedo, weight);
}

vec3 getContrast(vec3 albedo) {
    vec3 l = log2(albedo+1e-4);
    l = (l +1.0)*Contrast-1.0;
    return exp2(l)-1e-4;
}
void main() {
    vec4 albedo = texture2D(tex, texcoord) * color;
    float depth = texture2D(depthtex1, texcoord).x;

    #ifdef Vignette
    albedo.rgb = SoftVignette(albedo.rgb);
    #endif

    albedo.rgb = getSaturate(albedo.rgb);
    albedo.rgb = getContrast(albedo.rgb);


/*DRAWBUFFERS:0*/
    gl_FragColor = albedo;

}

