#version 120

varying vec2 texcoord;
varying vec4 color;

varying vec3 viewVector;
varying vec3 moonVec;

uniform vec3 moonPosition;

void main() {
    gl_Position = ftransform();

    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;

    moonVec = normalize(moonPosition);

    color = gl_Color;
}