#version 120

attribute vec4 mc_Entity;

uniform float rainStrength;
uniform float frameTimeCounter;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 color;

varying vec3 normal;

uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;

attribute vec4 at_tangent;

void main() {
    vec4 position = gl_Vertex;

    gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * position);
    
    texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

    lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    
    color = gl_Color;

    normal 	= normalize(gl_NormalMatrix*gl_Normal);

}