#version 120

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 color;

varying vec3 normal;
varying vec3 viewVector;

varying mat3 tbn;

uniform sampler2D tex;
uniform sampler2D specular;
uniform sampler2D normals;
uniform sampler2D depthtex0;

uniform int isEyeInWater;

uniform float frameTimeCounter;
uniform float rainStrength;

uniform mat4 gbufferModelViewInverse;

varying float id;

mat3 getLightmapTBN(vec3 viewPos){
    mat3 lmTBN = mat3(normalize(dFdx(viewPos)), normalize(dFdy(viewPos)), vec3(0.0));
    lmTBN[2] = cross(lmTBN[0], lmTBN[1]);
    return lmTBN;
}

void main() {
    vec3 normaltex = texture2D(normals, texcoord).rgb*2.0-1.0;
    normaltex = normalize(normaltex);
    normaltex = normalize(normaltex*tbn);
    vec4 albedo = texture2D(tex, texcoord) * color;
    vec4 speculart = texture2D(specular, texcoord);
/*DRAWBUFFERS:01234*/
    gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(normaltex*0.5+0.5, 1.0);
    gl_FragData[2] = vec4(lmcoord.xy, 0.0, 1.0);
    gl_FragData[3] = vec4(normal, id/255);
    gl_FragData[4] = speculart;
}