#version 120

#define TAA

uniform float rainStrength;
uniform float frameTimeCounter;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 color;

varying vec3 normal;
varying vec3 viewVector;

varying mat3 tbn;

uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;

attribute vec4 at_tangent;
attribute vec4 mc_Entity;

varying float id;

vec2 jitter[8] = vec2[8](vec2( 0.125,-0.375),
							   vec2(-0.125, 0.375),
							   vec2( 0.625, 0.125),
							   vec2( 0.375,-0.625),
							   vec2(-0.625, 0.625),
							   vec2(-0.875,-0.125),
							   vec2( 0.375,-0.875),
							   vec2( 0.875, 0.875));
				

vec2 taaJitter(vec2 coord, float w){
	return jitter[int(mod(frameCounter,8.0))]*(w/vec2(viewWidth,viewHeight)) + coord;
}
void main() {
	const float pi = 3.14159265f;

	float tick = frameTimeCounter;
    vec4 position = gl_Vertex;
	if (mc_Entity.x == 31.0 || mc_Entity.x == 32.0 || mc_Entity.x == 175.0 || mc_Entity.x == 18.0 || mc_Entity.x == 161.0) {
		float speed = 0.03;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.025 + 0.075) * 0.2;
		float d0 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (28.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.y += sin((tick * pi / (21.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 2.0f);
	}

	if (mc_Entity.x == 8 || mc_Entity.x == 9) {
		float displacement = 0.0;
		float fy = fract(position.y + 0.0001);
		
        float waveStrength = 0.8*0.05;
		
		float wave = (waveStrength + (rainStrength*0.125)) * sin(3 * pi * (frameTimeCounter*0.75 + position.x /  2.0 + position.z / 2.0))
		+ waveStrength * sin(3 * pi * (frameTimeCounter*0.6 + position.x / 2.0 + position.z /  2.0));
		displacement = clamp(wave, -fy, 1.0-fy);
		position.y += displacement;
	}

    gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * position);
    #ifdef TAA
    gl_Position.xy = taaJitter(gl_Position.xy, gl_Position.w);
    #endif
    
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    
    color = gl_Color;

    normal 	= normalize(gl_NormalMatrix*gl_Normal);
        vec3 tangent = normalize(gl_NormalMatrix*at_tangent.xyz);
        vec3 binormal = normalize(gl_NormalMatrix*cross(at_tangent.xyz, gl_Normal.xyz) * at_tangent.w);

        tbn     = mat3(tangent.x, binormal.x, normal.x,
                    tangent.y, binormal.y, normal.y,
                    tangent.z, binormal.z, normal.z);
    id = mc_Entity.x;

	viewVector = tbn*normalize(gl_ModelViewMatrix * gl_Vertex).xyz;

}