#version 120

#define bumpness 0.35 //[0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.7 0.8 0.9 1.0]
#define waterAlpha 0.9 //[0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.95]
#define WatercolorR 0.1 //[0.1 0.2 0.3 0.4 0.5]
#define WatercolorG 0.4 //[0.1 0.2 0.3 0.4 0.5]
#define WatercolorB 0.5 //[0.1 0.2 0.3 0.4 0.5]

const float PI = 3.1415927;
const float noiseTextureResolution = 32;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 wpos;
varying float iswater;
varying float id;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float far;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float noise2De(in vec2 coord, in float size, in vec2 offset) {
    coord      *= size;
    coord      += offset;
    coord      /= noiseTextureResolution;
    return texture2D(noisetex, coord).r*2.0-1.0;
}

float waterH(vec3 wpos) {
    float windAnim = -frameTimeCounter*0.2;
    
    vec2 tick = vec2(windAnim, 0.0);
    vec3 wind = vec3(tick.x, 0.5*windAnim, tick.y);

    vec3 rpos = wpos;
    rpos.y *= 0.0;

    float noise = noise2De(rpos.xz, 0.1, tick);
        noise += noise2De(rpos.xz, 0.4, tick*1.2)*0.25;
        noise += noise2De(rpos.xz, 1.6, tick*1.5)*0.025;
        noise += noise2De(rpos.xz, 1.8, tick*1.9)*0.0125;
	
    return noise * 0.12;
}

void main() {	
	vec4 tex = vec4(vec3(WatercolorR,WatercolorG,WatercolorB)*0.5, waterAlpha);
	if (iswater<0.9) tex = texture2D(texture, texcoord)*color;
	
	vec3 posxz = wpos.xyz;

	posxz.x += sin(posxz.x+frameTimeCounter)*0.25;
	posxz.z += cos(posxz.z+frameTimeCounter*0.5)*0.25;
	
	float delpos = 0.2;
            float h0 = waterH(posxz);
            float h1 = waterH(posxz + vec3(delpos,0.0,0.0));
            float h2 = waterH(posxz + vec3(-delpos,0.0,0.0));
            float h3 = waterH(posxz + vec3(0.0,0.0,delpos));
            float h4 = waterH(posxz + vec3(0.0,0.0,-delpos));
	
	float xDelta = (h1-h0)+(h0-h2);
	float yDelta = (h3-h0)+(h0-h4);
	float zDelta = h0-(h1+h2+h3+h4)/2.2;
	
	vec3 newnormal = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.2)));
	
	vec4 frag2;
		frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);		
		
	if (iswater > 0.9) {
		vec3 bump = newnormal;
			bump = bump;
			
		
		float bumpmult = bumpness;	
		
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
		
		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	}

/*DRAWBUFFERS:013*/
	gl_FragData[0] = tex;
	gl_FragData[1] = frag2;	
    gl_FragData[2] = vec4(vec2(normal), id/65535, 1.0);
}