vec4 getCameraSpacePos(in vec2 coord, in float depth) {
    float gdepth = depth;
    vec4 CameraSpacePos = gbufferProjectionInverse*vec4(coord.s * 2.0 - 1.0, coord.t * 2.0 - 1.0, 2.0 * gdepth - 1.0, 1.0);

    return CameraSpacePos / CameraSpacePos.w;
}


vec4 getWorldSpacePos(in vec2 coord, in float depth) {
    vec4 WorldSpacePos = gbufferModelViewInverse*getCameraSpacePos(coord, depth);
    WorldSpacePos.xyz += cameraPosition;

    return WorldSpacePos;
}


#define SHADOW_MAP_BIAS 0.85
vec2 getMultipliedShadowPos(in vec2 pos) {
    return pos*abs(pos)*1.357225;
}

vec3 getShadowSpacePos(in vec2 coord, in float depth, vec3 lightvec, float offset) {
    vec4 WorldSpacePos = getWorldSpacePos(coord, depth);

    WorldSpacePos.xyz -= cameraPosition;
    WorldSpacePos.xyz += mat3(gbufferModelViewInverse)*lightvec*offset;
    vec4 ShadowSpacePos = shadowProjection*(shadowModelView * WorldSpacePos);
    vec2 multipliedShadowPos = getMultipliedShadowPos(ShadowSpacePos.xy);
    float dist = pow(multipliedShadowPos.x*multipliedShadowPos.x + multipliedShadowPos.y*multipliedShadowPos.y, 1.0/4.0);
    float distFac = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
    ShadowSpacePos.xy /= distFac*0.92;
    ShadowSpacePos.z *= 0.2;  

    return ShadowSpacePos.xyz * 0.5 + 0.5;
}
