#version 120

attribute vec4 mc_Entity;

varying vec4 texcoord;
varying vec4 color;

varying vec3 normal;

#define SHADOW_MAP_BIAS 0.85
vec2 getMultipliedShadowPos(in vec2 pos) {
    return pos*abs(pos)*1.357225;
}

void main() {
    gl_Position = ftransform();
    vec2 multipliedShadowPos = getMultipliedShadowPos(gl_Position.xy);
    float dist = pow(multipliedShadowPos.x*multipliedShadowPos.x + multipliedShadowPos.y*multipliedShadowPos.y, 1.0/4.0);
    float distFac = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
    gl_Position.xy /= distFac*0.92;
    gl_Position.z = gl_Position.z * 0.2;
    texcoord = gl_MultiTexCoord0;
    color = gl_Color;
    normal = normalize(gl_NormalMatrix*gl_Normal);

}