/*
 * Decompiled with CFR 0.152.
 */
package com.serenity.extrareeds.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class GlowstoneReeds
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public GlowstoneReeds() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200947_a(SoundType.field_185850_c).func_200943_b(0.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else if (worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (soil.canSustainPlant((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (block == this) {
            return true;
        }
        if (block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150354_m || block == Blocks.field_196611_F) {
            BlockPos blockpos = pos.func_177977_b();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177972_a(direction));
                IFluidState ifluidstate = worldIn.func_204610_c(blockpos.func_177972_a(direction));
                if (!ifluidstate.func_206884_a(FluidTags.field_206959_a) && blockstate.func_177230_c() != Blocks.field_185778_de) continue;
                return true;
            }
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Beach;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

