/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSlotDimensions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class GuiAddWaypoint
extends GuiScreenMinimap
implements IPopupGuiScreen {
    IVoxelMap master;
    IWaypointManager waypointManager;
    IColorManager colorManager;
    private IGuiWaypoints parentGui;
    private PopupGuiButton doneButton;
    private GuiSlotDimensions dimensionList;
    protected DimensionContainer selectedDimension = null;
    private class_2561 tooltip = null;
    private class_342 waypointName;
    private class_342 waypointX;
    private class_342 waypointZ;
    private class_342 waypointY;
    private PopupGuiButton buttonEnabled;
    protected Waypoint waypoint;
    private boolean choosingColor = false;
    private boolean choosingIcon = false;
    private float red;
    private float green;
    private float blue;
    private String suffix;
    private boolean enabled;
    private boolean editing = false;
    private final class_2960 pickerResourceLocation = new class_2960("voxelmap", "images/colorpicker.png");

    public GuiAddWaypoint(IGuiWaypoints par1GuiScreen, IVoxelMap master, Waypoint par2Waypoint, boolean editing) {
        this.master = master;
        this.waypointManager = master.getWaypointManager();
        this.colorManager = master.getColorManager();
        this.parentGui = par1GuiScreen;
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.suffix = this.waypoint.imageSuffix;
        this.enabled = this.waypoint.enabled;
        this.editing = editing;
    }

    public void method_25393() {
        this.waypointName.method_1865();
        this.waypointX.method_1865();
        this.waypointY.method_1865();
        this.waypointZ.method_1865();
    }

    public void method_25426() {
        this.getMinecraft().field_1774.method_1462(true);
        this.getButtonList().clear();
        this.waypointName = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20, null);
        this.waypointName.method_1852(this.waypoint.name);
        this.waypointX = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointX.method_1880(128);
        this.waypointX.method_1852("" + this.waypoint.getX());
        this.waypointZ = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointZ.method_1880(128);
        this.waypointZ.method_1852("" + this.waypoint.getZ());
        this.waypointY = new class_342(this.getFontRenderer(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointY.method_1880(128);
        this.waypointY.method_1852("" + this.waypoint.getY());
        this.method_25411((class_339)this.waypointName);
        this.method_25411((class_339)this.waypointX);
        this.method_25411((class_339)this.waypointZ);
        this.method_25411((class_339)this.waypointY);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.buttonEnabled = new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 0, 100, 20, (class_2561)new class_2585("Enabled: " + (this.waypoint.enabled ? "On" : "Off")), button -> {
            this.waypoint.enabled = !this.waypoint.enabled;
        }, this);
        this.method_25411((class_339)this.buttonEnabled);
        this.method_25411((class_339)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 24, 100, 20, (class_2561)new class_2585(I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + ":     "), button -> {
            this.choosingColor = true;
        }, this));
        this.method_25411((class_339)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 48, 100, 20, (class_2561)new class_2585(I18nUtils.getString("minimap.waypoints.sortbyicon", new Object[0]) + ":     "), button -> {
            this.choosingIcon = true;
        }, this));
        this.doneButton = new PopupGuiButton(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, (class_2561)new class_2588("addServer.add"), button -> this.acceptWaypoint(), this);
        this.method_25411((class_339)this.doneButton);
        this.method_25411((class_339)new PopupGuiButton(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, (class_2561)new class_2588("gui.cancel"), button -> this.cancelWaypoint(), this));
        this.doneButton.field_22763 = this.waypointName.method_1882().length() > 0;
        this.method_25395((class_364)this.waypointName);
        this.waypointName.method_1876(true);
        this.dimensionList = new GuiSlotDimensions(this);
    }

    @Override
    public void method_25432() {
        this.getMinecraft().field_1774.method_1462(false);
    }

    protected void cancelWaypoint() {
        this.waypoint.red = this.red;
        this.waypoint.green = this.green;
        this.waypoint.blue = this.blue;
        this.waypoint.imageSuffix = this.suffix;
        this.waypoint.enabled = this.enabled;
        if (this.parentGui != null) {
            this.parentGui.accept(false);
        } else {
            this.getMinecraft().method_1507(null);
        }
    }

    protected void acceptWaypoint() {
        this.waypoint.name = this.waypointName.method_1882();
        this.waypoint.setX(Integer.parseInt(this.waypointX.method_1882()));
        this.waypoint.setZ(Integer.parseInt(this.waypointZ.method_1882()));
        this.waypoint.setY(Integer.parseInt(this.waypointY.method_1882()));
        if (this.parentGui != null) {
            this.parentGui.accept(true);
        } else {
            if (this.editing) {
                this.waypointManager.saveWaypoints();
            } else {
                this.waypointManager.addWaypoint(this.waypoint);
            }
            this.getMinecraft().method_1507(null);
        }
    }

    public boolean method_25404(int keysm, int scancode, int b) {
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.method_25404(keysm, scancode, b);
            boolean acceptable = this.waypointName.method_1882().length() > 0;
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
            }
            catch (NumberFormatException e) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
            if ((keysm == 257 || keysm == 335) && acceptable) {
                this.acceptWaypoint();
            }
        }
        return OK;
    }

    public boolean method_25400(char character, int keycode) {
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.method_25400(character, keycode);
            boolean acceptable = this.waypointName.method_1882().length() > 0;
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
            }
            catch (NumberFormatException e) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
        }
        return OK;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen()) {
            super.method_25402(mouseX, mouseY, mouseButton);
            this.waypointName.method_25402(mouseX, mouseY, mouseButton);
            this.waypointX.method_25402(mouseX, mouseY, mouseButton);
            this.waypointZ.method_25402(mouseX, mouseY, mouseButton);
            this.waypointY.method_25402(mouseX, mouseY, mouseButton);
        } else if (this.choosingColor) {
            if (mouseX >= (double)(this.getWidth() / 2 - 128) && mouseX < (double)(this.getWidth() / 2 + 128) && mouseY >= (double)(this.getHeight() / 2 - 128) && mouseY < (double)(this.getHeight() / 2 + 128)) {
                int color = this.colorManager.getColorPicker().getRGB((int)mouseX - (this.getWidth() / 2 - 128), (int)mouseY - (this.getHeight() / 2 - 128));
                this.waypoint.red = (float)(color >> 16 & 0xFF) / 255.0f;
                this.waypoint.green = (float)(color >> 8 & 0xFF) / 255.0f;
                this.waypoint.blue = (float)(color >> 0 & 0xFF) / 255.0f;
                this.choosingColor = false;
            }
        } else if (this.choosingIcon) {
            float y;
            float x;
            Sprite icon;
            float adj;
            float scScale = (float)this.getMinecraft().method_22683().method_4495();
            TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)this.getMinecraft().method_22683().method_4489()) {
                adj = displayWidthFloat / (float)this.getMinecraft().method_22683().method_4489();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)this.getMinecraft().method_22683().method_4506()) {
                adj = displayHeightFloat / (float)this.getMinecraft().method_22683().method_4506();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            if (mouseX >= (double)(this.getWidth() / 2 - displayWidth / 2) && mouseX < (double)(this.getWidth() / 2 + displayWidth / 2) && mouseY >= (double)(this.getHeight() / 2 - displayHeight / 2) && mouseY < (double)(this.getHeight() / 2 + displayHeight / 2) && (icon = chooser.getIconAt(x = ((float)mouseX - (float)(this.getWidth() / 2 - displayWidth / 2)) * scale, y = ((float)mouseY - (float)(this.getHeight() / 2 - displayHeight / 2)) * scale)) != chooser.getMissingImage()) {
                this.waypoint.imageSuffix = icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
                this.choosingIcon = false;
            }
        }
        if (!this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25402(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25406(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        if (!this.popupOpen() && this.dimensionList != null) {
            return this.dimensionList.method_25403(mouseX, mouseY, mouseEvent, deltaX, deltaY);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.popupOpen() && this.dimensionList != null) {
            return this.dimensionList.method_25401(mouseX, mouseY, amount);
        }
        return true;
    }

    @Override
    public boolean overPopup(int x, int y) {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public boolean popupOpen() {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        float scScale = (float)this.getMinecraft().method_22683().method_4495();
        this.tooltip = null;
        this.buttonEnabled.method_25355((class_2561)new class_2585(I18nUtils.getString("minimap.waypoints.enabled", new Object[0]) + " " + (this.waypoint.enabled ? I18nUtils.getString("options.on", new Object[0]) : I18nUtils.getString("options.off", new Object[0]))));
        if (!this.choosingColor && !this.choosingIcon) {
            this.method_25420(matrixStack);
        }
        this.dimensionList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        GuiAddWaypoint.method_25300((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)(this.parentGui != null && this.parentGui.isEditing() || this.editing ? I18nUtils.getString("minimap.waypoints.edit", new Object[0]) : I18nUtils.getString("minimap.waypoints.new", new Object[0])), (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        GuiAddWaypoint.method_25303((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)I18nUtils.getString("minimap.waypoints.name", new Object[0]), (int)(this.getWidth() / 2 - 100), (int)(this.getHeight() / 6 + 0), (int)0xA0A0A0);
        GuiAddWaypoint.method_25303((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)I18nUtils.getString("X", new Object[0]), (int)(this.getWidth() / 2 - 100), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        GuiAddWaypoint.method_25303((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)I18nUtils.getString("Z", new Object[0]), (int)(this.getWidth() / 2 - 28), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        GuiAddWaypoint.method_25303((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)I18nUtils.getString("Y", new Object[0]), (int)(this.getWidth() / 2 + 44), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        this.waypointName.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointX.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointZ.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointY.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        GLShim.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
        GLUtils.disp(-1);
        this.method_25302(matrixStack, this.getWidth() / 2 - 25, buttonListY + 24 + 5, 0, 0, 16, 10);
        TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
        GLUtils.disp(chooser.method_4624());
        GLShim.glTexParameteri(3553, 10241, 9729);
        Sprite icon = chooser.getAtlasSprite("voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png");
        this.drawTexturedModalRect(this.getWidth() / 2 - 25, buttonListY + 48 + 2, icon, 16.0f, 16.0f);
        if (this.choosingColor || this.choosingIcon) {
            this.method_25420(matrixStack);
        }
        if (this.choosingColor) {
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img(this.pickerResourceLocation);
            GLShim.glTexParameteri(3553, 10241, 9728);
            this.method_25302(matrixStack, this.getWidth() / 2 - 128, this.getHeight() / 2 - 128, 0, 0, 256, 256);
        }
        if (this.choosingIcon) {
            float y;
            float x;
            float adj;
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)this.getMinecraft().method_22683().method_4489()) {
                adj = displayWidthFloat / (float)this.getMinecraft().method_22683().method_4489();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)this.getMinecraft().method_22683().method_4506()) {
                adj = displayHeightFloat / (float)this.getMinecraft().method_22683().method_4506();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            GLUtils.disp(-1);
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
            this.method_25302(matrixStack, this.getWidth() / 2 - displayWidth / 2 - 1, this.getHeight() / 2 - displayHeight / 2 - 1, 0, 0, displayWidth + 2, displayHeight + 2);
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.method_25302(matrixStack, this.getWidth() / 2 - displayWidth / 2, this.getHeight() / 2 - displayHeight / 2, 0, 0, displayWidth, displayHeight);
            GLShim.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
            GLShim.glEnable(3042);
            GLUtils.disp(chooser.method_4624());
            GLShim.glTexParameteri(3553, 10241, 9729);
            GuiAddWaypoint.method_25293((class_4587)matrixStack, (int)(this.getWidth() / 2 - displayWidth / 2), (int)(this.getHeight() / 2 - displayHeight / 2), (int)displayWidth, (int)displayHeight, (float)0.0f, (float)0.0f, (int)chooser.getWidth(), (int)chooser.getHeight(), (int)chooser.getImageWidth(), (int)chooser.getImageHeight());
            if (mouseX >= this.getWidth() / 2 - displayWidth / 2 && mouseX <= this.getWidth() / 2 + displayWidth / 2 && mouseY >= this.getHeight() / 2 - displayHeight / 2 && mouseY <= this.getHeight() / 2 + displayHeight / 2 && (icon = chooser.getIconAt(x = (float)(mouseX - (this.getWidth() / 2 - displayWidth / 2)) * scale, y = (float)(mouseY - (this.getHeight() / 2 - displayHeight / 2)) * scale)) != chooser.getMissingImage()) {
                this.tooltip = new class_2585(icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", ""));
            }
            GLShim.glDisable(3042);
            GLShim.glTexParameteri(3553, 10241, 9728);
        }
        if (this.tooltip != null) {
            this.method_25424(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public void setSelectedDimension(DimensionContainer dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension) && this.selectedDimension != this.master.getDimensionManager().getDimensionContainerByWorld((class_1937)class_310.method_1551().field_1687)) {
            this.waypoint.dimensions.remove(this.selectedDimension);
        } else if (!this.waypoint.dimensions.contains(this.selectedDimension)) {
            this.waypoint.dimensions.add(this.selectedDimension);
        }
    }

    static class_2561 setTooltip(GuiAddWaypoint par0GuiWaypoint, class_2561 par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
        return par0GuiWaypoint.tooltip;
    }

    public void drawTexturedModalRect(Sprite icon, float x, float y) {
        float width = (float)icon.getIconWidth() / 2.0f;
        float height = (float)icon.getIconHeight() / 2.0f;
        this.drawTexturedModalRect(x, y, icon, width, height);
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(7, class_290.field_1585);
        vertexbuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + heightIn), (double)this.method_25305()).method_22913(icon.getMinU(), icon.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)this.method_25305()).method_22913(icon.getMaxU(), icon.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + 0.0f), (double)this.method_25305()).method_22913(icon.getMaxU(), icon.getMinV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.method_25305()).method_22913(icon.getMinU(), icon.getMinV()).method_1344();
        tessellator.method_1350();
    }
}

