/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.FallingTreeUtils;
import fr.raksrinana.fallingtree.LeafBreakingSchedule;
import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import io.netty.util.internal.ConcurrentSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="falling_tree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = new ConcurrentSet();

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getWorld().func_201670_d() && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && event.getWorld() instanceof World) {
            TreeHandler.getTree((World)event.getWorld(), event.getPos()).ifPresent(tree -> {
                if (Config.COMMON.getTreesConfiguration().getMaxSize() >= tree.getLogCount()) {
                    if (!TreeHandler.destroy(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                        event.setCanceled(true);
                    }
                } else {
                    event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), Config.COMMON.getTreesConfiguration().getMaxSize()}), Util.field_240973_b_);
                }
            });
        }
    }

    private static boolean isPlayerInRightState(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d && !FallingTree.isDevBuild()) {
            return false;
        }
        if (Config.COMMON.isReverseSneaking() != player.func_213453_ef()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player);
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (Config.COMMON.getTreesConfiguration().isLavesBreaking() && !event.getWorld().func_201670_d()) {
            BlockPos eventPos;
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockReader)world, eventPos = event.getPos())) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.func_175667_e(neighborPos) || !FallingTreeUtils.isLeafBlock((neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c())) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                ServerWorld world = leafBreakingSchedule.getWorld();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    if (world.func_175667_e(leafBreakingSchedule.getBlockPos())) {
                        BlockState state = world.func_180495_p(leafBreakingSchedule.getBlockPos());
                        Block block = state.func_177230_c();
                        if (FallingTreeUtils.isLeafBlock(block)) {
                            block.func_225542_b_(state, world, leafBreakingSchedule.getBlockPos(), world.func_201674_k());
                            continue;
                        }
                        leavesBreak.remove();
                        continue;
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }
}

