/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import com.google.common.collect.Lists;
import fr.raksrinana.fallingtree.FallingTreeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class ToolConfiguration {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelisted;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklisted;
    private final ForgeConfigSpec.BooleanValue preserve;
    private final ForgeConfigSpec.IntValue damageMultiplicand;

    public ToolConfiguration(ForgeConfigSpec.Builder builder) {
        this.whitelisted = builder.comment("Additional list of tools (those marked with the axe tag will already be whitelisted) that can be used to chop down a tree").defineList("whitelisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.blacklisted = builder.comment("List of tools that should not be considered as tools (this wins over the whitelist)").defineList("blacklisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.damageMultiplicand = builder.comment("Defines the number of times the damage is applied to the tool (ie: if 1 then breaking 5 logs will give 5 damage; if set to 2, breaking 5 logs will give 10 damage; if set to 0 it'll still apply 1 damage for every cut). This only applies when the tree is cut when using the mod.").defineInRange("damage_multiplicand", 1, 0, Integer.MAX_VALUE);
        this.preserve = builder.comment("When set to true, when a tree is broken and the tool is about to break we will just break enough blocks so that the tool is left at 1 of durability.").define("preserve", false);
    }

    public Collection<Item> getBlacklisted() {
        return FallingTreeUtils.getAsItems((Collection)this.blacklisted.get());
    }

    public Collection<Item> getWhitelisted() {
        return FallingTreeUtils.getAsItems((Collection)this.whitelisted.get());
    }

    public boolean isPreserve() {
        return (Boolean)this.preserve.get();
    }

    public int getDamageMultiplicand() {
        return (Integer)this.damageMultiplicand.get();
    }
}

