/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import fr.raksrinana.fallingtree.FallingTreeUtils;
import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.tree.Tree;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TreeHandler {
    @Nonnull
    public static Optional<Tree> getTree(@Nonnull World world, @Nonnull BlockPos blockPos) {
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        if (!FallingTreeUtils.isTreeBlock(logBlock)) {
            return Optional.empty();
        }
        LinkedList<BlockPos> toAnalyzePos = new LinkedList<BlockPos>();
        HashSet<BlockPos> analyzedPos = new HashSet<BlockPos>();
        Tree tree = new Tree(world, blockPos);
        toAnalyzePos.add(blockPos);
        while (!toAnalyzePos.isEmpty()) {
            BlockPos analyzingPos = (BlockPos)toAnalyzePos.remove();
            tree.addLog(analyzingPos);
            analyzedPos.add(analyzingPos);
            Collection<BlockPos> nearbyPos = TreeHandler.neighborLogs((IWorld)world, logBlock, analyzingPos, analyzedPos);
            nearbyPos.removeAll(analyzedPos);
            toAnalyzePos.addAll(nearbyPos.stream().filter(pos -> !toAnalyzePos.contains(pos)).collect(Collectors.toList()));
        }
        return Optional.of(tree);
    }

    @Nonnull
    private static Collection<BlockPos> neighborLogs(@Nonnull IWorld world, @Nonnull Block logBlock, @Nonnull BlockPos blockPos, @Nonnull Collection<BlockPos> analyzedPos) {
        LinkedList<BlockPos> neighborLogs = new LinkedList<BlockPos>();
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    checkPos.func_181079_c(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z);
                    if (analyzedPos.contains(checkPos) || !TreeHandler.isSameLog(world, (BlockPos)checkPos, logBlock)) continue;
                    neighborLogs.add(checkPos.func_185334_h());
                }
            }
        }
        neighborLogs.addAll(analyzedPos);
        return neighborLogs;
    }

    private static boolean isSameLog(@Nonnull IWorld world, @Nonnull BlockPos blockPos, @Nullable Block logBlock) {
        return world.func_180495_p(blockPos).func_177230_c().equals(logBlock);
    }

    public static boolean destroy(@Nonnull Tree tree, @Nonnull PlayerEntity player, @Nonnull ItemStack tool) {
        int radius;
        double rawWeightedUsesLeft;
        World world = tree.getWorld();
        int damageMultiplicand = Config.COMMON.getToolsConfiguration().getDamageMultiplicand();
        int toolUsesLeft = tool.func_77984_f() ? tool.func_77958_k() - tool.func_77952_i() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (Config.COMMON.getToolsConfiguration().isPreserve()) {
            if (rawWeightedUsesLeft <= 1.0) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.falling_tree.prevented_break_tool"), Util.field_240973_b_);
                return false;
            }
            if ((double)tree.getLogCount() >= rawWeightedUsesLeft) {
                rawWeightedUsesLeft = Math.ceil(rawWeightedUsesLeft) - 1.0;
            }
        }
        boolean isTreeFullyBroken = damageMultiplicand == 0 || rawWeightedUsesLeft >= (double)tree.getLogCount();
        tree.getLogs().stream().limit((int)rawWeightedUsesLeft).forEachOrdered(logBlock -> {
            BlockState logState = world.func_180495_p(logBlock);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)logState.func_177230_c().func_199767_j()));
            logState.func_177230_c().func_180657_a(world, player, logBlock, logState, world.func_175625_s(logBlock), tool);
            world.func_175655_b(logBlock, false);
        });
        int toolDamage = damageMultiplicand * (int)Math.min((double)tree.getLogCount(), rawWeightedUsesLeft) - 1;
        if (toolDamage > 0) {
            tool.func_222118_a(toolDamage, (LivingEntity)player, entity -> {});
        }
        if (isTreeFullyBroken && (radius = Config.COMMON.getTreesConfiguration().getLavesBreakingForceRadius()) > 0) {
            tree.getLogs().stream().max(Comparator.comparingInt(Vector3i::func_177956_o)).ifPresent(topLog -> {
                BlockPos.Mutable checkPos = new BlockPos.Mutable();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.func_181079_c(topLog.func_177958_n() + dx, topLog.func_177956_o() + dy, topLog.func_177952_p() + dz);
                            BlockState checkState = world.func_180495_p((BlockPos)checkPos);
                            Block checkBlock = checkState.func_177230_c();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            Block.func_220075_c((BlockState)checkState, (World)world, (BlockPos)checkPos);
                            world.func_217377_a((BlockPos)checkPos, false);
                        }
                    }
                }
            });
        }
        return true;
    }
}

