/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.legacy.structure_gel.structures.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class StructureData {
    public final int seed;
    public final int spacing;
    public final int offset;
    public final int minY;
    public final int maxY;
    public final double probability;
    public final ResourceLocation registryName;
    public final ResourceLocation startPool;
    public final List<Biome> biomes;

    public StructureData(ResourceLocation name, ResourceLocation startPool, int seed, int spacing, int offset, double probability, List<Biome> biomes, int minY, int maxY) {
        this.registryName = name;
        this.startPool = startPool;
        this.seed = seed;
        this.spacing = spacing;
        this.offset = offset;
        this.probability = probability;
        this.biomes = biomes;
        this.minY = minY;
        this.maxY = maxY;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getProbability() {
        return this.probability;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getOffset() {
        return this.offset;
    }

    public static StructureData parse(JsonObject json, String path) throws JsonSyntaxException {
        if (!JSONUtils.func_151205_a((JsonObject)json, (String)"name")) {
            StructureData.throwJson("string", "name", path);
        }
        if (!JSONUtils.func_151205_a((JsonObject)json, (String)"start_pool")) {
            StructureData.throwJson("string", "start_pool", path);
        }
        ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        ResourceLocation startPool = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"start_pool"));
        JsonObject properties = JSONUtils.func_151218_a((JsonObject)json, (String)"properties", (JsonObject)new JsonObject());
        int seed = JSONUtils.func_151208_a((JsonObject)properties, (String)"seed", (int)1461684410);
        int spacing = JSONUtils.func_151208_a((JsonObject)properties, (String)"spacing", (int)12);
        int offset = JSONUtils.func_151208_a((JsonObject)properties, (String)"offset", (int)5);
        double probability = JSONUtils.func_151221_a((JsonObject)properties, (String)"probability", (float)1.0f);
        List<Biome> biomes = ConfigTemplates.BiomeStructureConfig.parseBiomes(JSONUtils.func_151219_a((JsonObject)properties, (String)"biomes", (String)""));
        JsonObject placement = JSONUtils.func_151218_a((JsonObject)properties, (String)"placement", (JsonObject)new JsonObject());
        int minY = placement.has("min_y") ? JSONUtils.func_151203_m((JsonObject)placement, (String)"min_y") : -1;
        int maxY = placement.has("max_y") ? JSONUtils.func_151203_m((JsonObject)placement, (String)"max_y") : -1;
        JSONUtils.func_151213_a((JsonObject)json, (String)"pools", (JsonArray)new JsonArray()).forEach(j -> {
            if (j.isJsonObject()) {
                StructureData.parsePool(j.getAsJsonObject(), path);
            }
        });
        return new StructureData(name, startPool, seed, spacing, offset, probability, biomes, minY, maxY);
    }

    private static void parsePool(JsonObject json, String path) throws JsonSyntaxException {
        if (!JSONUtils.func_151205_a((JsonObject)json, (String)"name")) {
            StructureData.throwJson("string", "name", path);
        }
        if (!JSONUtils.func_151202_d((JsonObject)json, (String)"pieces")) {
            StructureData.throwJson("array", "pieces", path);
        }
        ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        ResourceLocation defaultPool = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"default_pool", (String)"minecraft:empty"));
        JigsawPattern.PlacementBehaviour poolPlacement = JigsawPattern.PlacementBehaviour.func_214938_a((String)JSONUtils.func_151219_a((JsonObject)json, (String)"placement", (String)JigsawPattern.PlacementBehaviour.RIGID.func_214936_a()));
        JigsawRegistryHelper registry = new JigsawRegistryHelper("");
        ArrayList<JigsawPoolBuilder> builders = new ArrayList<JigsawPoolBuilder>();
        JSONUtils.func_151214_t((JsonObject)json, (String)"pieces").forEach(j -> {
            if (j.isJsonObject()) {
                JsonObject jsonObj = j.getAsJsonObject();
                if (!JSONUtils.func_151205_a((JsonObject)jsonObj, (String)"piece")) {
                    StructureData.throwJson("string", "piece", path);
                }
                ResourceLocation pieceName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"piece"));
                int weight = JSONUtils.func_151208_a((JsonObject)jsonObj, (String)"weight", (int)1);
                boolean maintainWater = JSONUtils.func_151209_a((JsonObject)jsonObj, (String)"maintain_water", (boolean)true);
                JigsawPattern.PlacementBehaviour piecePlacement = JigsawPattern.PlacementBehaviour.func_214938_a((String)JSONUtils.func_151219_a((JsonObject)jsonObj, (String)"placement", (String)JigsawPattern.PlacementBehaviour.RIGID.func_214936_a()));
                List<StructureProcessor> processors = StructureData.parseProcessors(jsonObj, path);
                builders.add(registry.builder().weight(weight).namesR(pieceName).maintainWater(maintainWater).placementBehavior(piecePlacement).processors(processors));
            }
        });
        registry.register(name, defaultPool, JigsawPoolBuilder.collect(builders), poolPlacement);
    }

    private static List<StructureProcessor> parseProcessors(JsonObject json, String path) throws JsonSyntaxException {
        ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>();
        JSONUtils.func_151213_a((JsonObject)json, (String)"processors", (JsonArray)new JsonArray()).forEach(j -> {
            if (j.isJsonObject()) {
                ResourceLocation name;
                Optional optional;
                JsonObject jsonObj = j.getAsJsonObject();
                if (!JSONUtils.func_151205_a((JsonObject)jsonObj, (String)"name")) {
                    StructureData.throwJson("string", "name", path);
                }
                if (!JSONUtils.func_151204_g((JsonObject)jsonObj, (String)"data")) {
                    StructureData.throwJson("json object", "data", path);
                }
                if ((optional = Registry.field_218364_E.func_218349_b(name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"name")))).isPresent()) {
                    DataResult data = ((IStructureProcessorType)optional.get()).codec().parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)JSONUtils.func_152754_s((JsonObject)jsonObj, (String)"data"))).map(sj -> null);
                    processors.add((StructureProcessor)data.get().left().get());
                } else {
                    throw new IllegalArgumentException(String.format("%s is not a registered structure processor type.", name));
                }
            }
        });
        return processors;
    }

    private static void throwJson(String type, String fieldName, String path) {
        throw new JsonSyntaxException(String.format("Expected to find the %s \"%s\" in \"%s\" but it was not present.", type, fieldName, path));
    }
}

